/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.databinding.jaxb.mapper;

import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import org.fabric3.databinding.jaxb.mapper.JAXBQNameMapper;

public class JAXBQNameMapperImpl
implements JAXBQNameMapper {
    @Override
    public QName deriveQName(Class<?> type) {
        QName name;
        XmlType xmlType = type.getAnnotation(XmlType.class);
        if (xmlType != null) {
            String localName;
            String namespace = xmlType.namespace();
            if ("##default".equals(namespace)) {
                namespace = this.deriveNamespace(type);
            }
            if ("##default".equals(localName = xmlType.name())) {
                localName = this.deriveLocalName(type);
            }
            name = new QName(namespace, localName);
        } else {
            String namespace = this.deriveNamespace(type);
            String localName = this.deriveLocalName(type);
            name = new QName(namespace, localName);
        }
        return name;
    }

    String deriveNamespace(Class<?> type) {
        Package thePackage = type.getPackage();
        if (thePackage == null) {
            return null;
        }
        String pkg = thePackage.getName();
        String[] tokens = pkg.split("\\.");
        StringBuilder builder = new StringBuilder("http://");
        for (int i = tokens.length - 1; i >= 0; --i) {
            String token = tokens[i];
            builder.append(token);
            if (i != 0) {
                builder.append(".");
                continue;
            }
            builder.append("/");
        }
        return builder.toString();
    }

    private String deriveLocalName(Class<?> type) {
        String simpleName = type.getSimpleName();
        String localName = simpleName.substring(0, 1).toLowerCase() + simpleName.substring(1);
        return localName;
    }
}

