/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.databinding.jaxb.introspection;

import java.beans.Introspector;
import java.lang.reflect.Method;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchema;
import javax.xml.bind.annotation.XmlType;
import org.fabric3.api.model.type.contract.DataType;
import org.fabric3.api.model.type.contract.Operation;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.java.contract.TypeIntrospector;
import org.fabric3.spi.model.type.java.JavaType;

public class JAXBTypeIntrospector
implements TypeIntrospector {
    private static final String JAXB = "JAXB";
    private static final String DEFAULT = "##default";

    public void introspect(Operation operation, Method method, IntrospectionContext context) {
        List inputTypes = operation.getInputTypes();
        for (DataType type : inputTypes) {
            if (!(type instanceof JavaType)) {
                throw new AssertionError((Object)("Java contracts must use " + JavaType.class));
            }
            this.introspect(type);
        }
        for (DataType type : operation.getFaultTypes()) {
            if (!(type instanceof JavaType)) {
                throw new AssertionError((Object)("Java contracts must use " + JavaType.class));
            }
            this.introspect(type);
        }
        DataType outputType = operation.getOutputType();
        if (!(outputType instanceof JavaType)) {
            throw new AssertionError((Object)("Java contracts must use " + JavaType.class));
        }
        this.introspect(outputType);
    }

    public void introspect(DataType dataType) {
        Class type = dataType.getType();
        XmlRootElement annotation = type.getAnnotation(XmlRootElement.class);
        if (annotation != null) {
            String namespace = annotation.namespace();
            if (DEFAULT.equals(namespace)) {
                namespace = this.getDefaultNamespace(type);
            }
            dataType.setDatabinding(JAXB);
            return;
        }
        XmlType typeAnnotation = type.getAnnotation(XmlType.class);
        if (typeAnnotation != null) {
            String namespace = typeAnnotation.namespace();
            if (DEFAULT.equals(namespace)) {
                namespace = this.getDefaultNamespace(type);
            }
            String name = typeAnnotation.name();
            if (DEFAULT.equals(namespace)) {
                name = Introspector.decapitalize(type.getSimpleName());
            }
            dataType.setDatabinding(JAXB);
        }
    }

    private String getDefaultNamespace(Class clazz) {
        Package pkg = clazz.getPackage();
        if (pkg != null) {
            XmlSchema schemaAnnotation = pkg.getAnnotation(XmlSchema.class);
            if (schemaAnnotation != null) {
                return schemaAnnotation.namespace();
            }
            return pkg.getName();
        }
        return "";
    }
}

