/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.resource.runtime;

import java.net.URI;
import java.util.function.Supplier;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.resource.provision.SourcedWireTarget;
import org.fabric3.resource.runtime.ApplicationResourceRegistry;
import org.fabric3.spi.container.builder.TargetWireAttacher;
import org.fabric3.spi.container.component.AtomicComponent;
import org.fabric3.spi.container.component.ComponentManager;
import org.fabric3.spi.container.wire.Wire;
import org.fabric3.spi.model.physical.PhysicalWireSource;
import org.oasisopen.sca.annotation.Reference;

public class SourcedResourceWireAttacher
implements TargetWireAttacher<SourcedWireTarget> {
    private ApplicationResourceRegistry resourceRegistry;
    private ComponentManager manager;

    public SourcedResourceWireAttacher(@Reference ApplicationResourceRegistry resourceRegistry, @Reference ComponentManager manager) {
        this.resourceRegistry = resourceRegistry;
        this.manager = manager;
    }

    public void attach(PhysicalWireSource source, SourcedWireTarget target, Wire wire) throws Fabric3Exception {
        throw new AssertionError();
    }

    public Supplier<?> createSupplier(SourcedWireTarget target) throws Fabric3Exception {
        String name = target.getUri().toString();
        Supplier<?> supplier = this.resourceRegistry.getResourceFactory(name);
        if (supplier != null) {
            return supplier;
        }
        URI systemId = URI.create("fabric3://runtime/" + name);
        AtomicComponent targetComponent = (AtomicComponent)this.manager.getComponent(systemId);
        if (targetComponent == null) {
            throw new Fabric3Exception("Resource not found: " + systemId);
        }
        return targetComponent.createSupplier();
    }
}

