/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.management.rest.transformer;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.model.type.contract.DataType;
import org.fabric3.management.rest.transformer.TransformerPair;
import org.fabric3.management.rest.transformer.TransformerPairService;
import org.fabric3.spi.model.type.java.JavaType;
import org.fabric3.spi.transform.Transformer;
import org.fabric3.spi.transform.TransformerRegistry;
import org.oasisopen.sca.annotation.Reference;

public class TransformerPairServiceImpl
implements TransformerPairService {
    private static final JavaType JAVA_TYPE = new JavaType(Object.class);
    private TransformerRegistry registry;

    public TransformerPairServiceImpl(@Reference TransformerRegistry registry) {
        this.registry = registry;
    }

    @Override
    public TransformerPair getTransformerPair(List<Method> methods, DataType inputType, DataType outputType) throws Fabric3Exception {
        JavaType type;
        ArrayList list = new ArrayList();
        if (methods.size() == 1) {
            Method method = methods.get(0);
            type = Void.TYPE.equals(method.getReturnType()) && method.getParameterTypes().length == 1 ? new JavaType(method.getParameterTypes()[0]) : JAVA_TYPE;
        } else {
            for (Method method : methods) {
                list.addAll(Arrays.asList(method.getParameterTypes()));
                list.addAll(Arrays.asList(method.getExceptionTypes()));
                list.add(method.getReturnType());
            }
            type = JAVA_TYPE;
        }
        Transformer deserializer = this.registry.getTransformer(inputType, (DataType)type, list, list);
        Transformer serializer = this.registry.getTransformer((DataType)type, outputType, list, list);
        return new TransformerPair((Transformer<InputStream, Object>)deserializer, (Transformer<Object, byte[]>)serializer);
    }
}

