/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.management.rest.runtime;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.fabric3.api.Role;
import org.fabric3.api.annotation.management.Management;
import org.fabric3.api.annotation.management.ManagementOperation;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.model.type.contract.DataType;
import org.fabric3.api.model.type.java.ManagementInfo;
import org.fabric3.api.model.type.java.ManagementOperationInfo;
import org.fabric3.api.model.type.java.OperationType;
import org.fabric3.management.rest.framework.DynamicResourceService;
import org.fabric3.management.rest.runtime.ManagementSecurity;
import org.fabric3.management.rest.runtime.Marshaller;
import org.fabric3.management.rest.runtime.MethodHelper;
import org.fabric3.management.rest.runtime.PathHelper;
import org.fabric3.management.rest.runtime.ResourceInvoker;
import org.fabric3.management.rest.spi.ResourceHost;
import org.fabric3.management.rest.spi.ResourceListener;
import org.fabric3.management.rest.spi.ResourceMapping;
import org.fabric3.management.rest.spi.Verb;
import org.fabric3.management.rest.transformer.TransformerPair;
import org.fabric3.management.rest.transformer.TransformerPairService;
import org.fabric3.spi.management.ManagementExtension;
import org.fabric3.spi.model.type.java.JavaType;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Property;
import org.oasisopen.sca.annotation.Reference;

public class RestfulManagementExtension
implements ManagementExtension {
    private static final JavaType JSON_INPUT_TYPE = new JavaType(InputStream.class, "JSON");
    private static final JavaType JSON_OUTPUT_TYPE = new JavaType(byte[].class, "JSON");
    private static final String EMPTY_PATH = "";
    private static final String ROOT_PATH = "/";
    private TransformerPairService pairService;
    private Method rootResourceMethod;
    private Method dynamicGetResourceMethod;
    private ResourceHost resourceHost;
    private ManagementSecurity security = ManagementSecurity.DISABLED;
    private List<ResourceListener> listeners = new ArrayList<ResourceListener>();
    private Map<String, ResourceMapping> dynamicResources = new ConcurrentHashMap<String, ResourceMapping>();

    public RestfulManagementExtension(@Reference TransformerPairService pairService, @Reference Marshaller marshaller, @Reference ResourceHost resourceHost) {
        this.pairService = pairService;
        this.resourceHost = resourceHost;
    }

    @Property(required=false)
    public void setSecurity(String level) throws Fabric3Exception {
        try {
            this.security = ManagementSecurity.valueOf(level.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new Fabric3Exception("Invalid management security setting:" + level);
        }
    }

    @Reference(required=false)
    public void setListeners(List<ResourceListener> listeners) {
        this.listeners = listeners;
    }

    @Init
    public void init() throws NoSuchMethodException {
        this.rootResourceMethod = ResourceInvoker.class.getMethod("invoke", HttpServletRequest.class);
        this.dynamicGetResourceMethod = DynamicResourceService.class.getMethod("getResource", HttpServletRequest.class);
    }

    public String getType() {
        return "fabric3.rest";
    }

    public void export(URI componentUri, ManagementInfo info, Supplier<?> supplier) throws Fabric3Exception {
        String root = info.getPath();
        if (root.length() == 0) {
            root = componentUri.getPath();
        }
        ArrayList<ResourceMapping> getMappings = new ArrayList<ResourceMapping>();
        String identifier = componentUri.toString();
        boolean rootResourcePathOverride = false;
        for (ManagementOperationInfo operationInfo : info.getOperations()) {
            String path = operationInfo.getPath();
            if (!ROOT_PATH.equals(path)) continue;
            rootResourcePathOverride = true;
        }
        for (ManagementOperationInfo operationInfo : info.getOperations()) {
            TransformerPair pair;
            ResourceMapping mapping;
            Method method = operationInfo.getMethod();
            String path = operationInfo.getPath();
            OperationType type = operationInfo.getOperationType();
            Verb verb = this.getVerb(method, type);
            Set roles = operationInfo.getRoles();
            if (roles.isEmpty()) {
                roles = Verb.GET == verb ? info.getReadRoles() : info.getWriteRoles();
            }
            if (Verb.GET == (mapping = this.createMapping(identifier, root, path, method, verb, supplier, pair = this.pairService.getTransformerPair(Collections.singletonList(method), (DataType)JSON_INPUT_TYPE, (DataType)JSON_OUTPUT_TYPE), roles)).getVerb()) {
                getMappings.add(mapping);
            }
            this.createDynamicResources(mapping, root, rootResourcePathOverride);
            if (this.dynamicResources.remove(mapping.getPath()) != null) {
                this.resourceHost.unregisterPath(mapping.getPath(), mapping.getVerb());
            }
            this.resourceHost.register(mapping);
            this.notifyExport(path, mapping);
        }
        if (!rootResourcePathOverride) {
            this.createRootResource(identifier, root, getMappings);
        }
    }

    public void export(String name, String group, String description, Object instance) throws Fabric3Exception {
        String root = "/runtime/" + name;
        HashSet<Role> readRoles = new HashSet<Role>();
        HashSet<Role> writeRoles = new HashSet<Role>();
        this.parseRoles(instance, readRoles, writeRoles);
        boolean rootResourcePathOverride = false;
        ArrayList<ResourceMapping> getMappings = new ArrayList<ResourceMapping>();
        List<Method> methods = Arrays.asList(instance.getClass().getMethods());
        for (Method method : methods) {
            String path;
            ManagementOperation opAnnotation = method.getAnnotation(ManagementOperation.class);
            if (opAnnotation == null || !ROOT_PATH.equals(path = opAnnotation.path())) continue;
            rootResourcePathOverride = true;
        }
        for (Method method : methods) {
            HashSet<Role> roles;
            ManagementOperation opAnnotation = method.getAnnotation(ManagementOperation.class);
            if (opAnnotation == null) continue;
            OperationType type = OperationType.valueOf((String)opAnnotation.type().toString());
            Verb verb = this.getVerb(method, type);
            String[] rolesAllowed = opAnnotation.rolesAllowed();
            if (rolesAllowed.length == 0) {
                roles = Verb.GET == verb ? readRoles : writeRoles;
            } else {
                roles = new HashSet();
                for (String roleName : rolesAllowed) {
                    roles.add(new Role(roleName));
                }
            }
            TransformerPair pair = this.pairService.getTransformerPair(Collections.singletonList(method), (DataType)JSON_INPUT_TYPE, (DataType)JSON_OUTPUT_TYPE);
            ResourceMapping mapping = this.createMapping(name, root, EMPTY_PATH, method, verb, instance, pair, roles);
            if (Verb.GET == mapping.getVerb()) {
                getMappings.add(mapping);
            }
            this.createDynamicResources(mapping, root, rootResourcePathOverride);
            this.resourceHost.register(mapping);
            this.notifyExport(mapping.getRelativePath(), mapping);
        }
        if (!rootResourcePathOverride) {
            this.createRootResource(name, root, getMappings);
        }
    }

    public void remove(URI componentUri, ManagementInfo info) throws Fabric3Exception {
        String identifier = componentUri.toString();
        this.resourceHost.unregister(identifier);
        for (ResourceListener listener : this.listeners) {
            listener.onRootResourceRemove(identifier);
            listener.onSubResourceRemove(identifier);
        }
    }

    public void remove(String name, String group) throws Fabric3Exception {
        this.resourceHost.unregister(name);
        for (ResourceListener listener : this.listeners) {
            listener.onRootResourceRemove(name);
            listener.onSubResourceRemove(name);
        }
    }

    private Verb getVerb(Method method, OperationType type) {
        String methodName = method.getName();
        if (OperationType.UNDEFINED == type) {
            return MethodHelper.convertToVerb(methodName);
        }
        return Verb.valueOf(type.toString());
    }

    private void notifyExport(String path, ResourceMapping mapping) {
        if (ROOT_PATH.equals(path)) {
            for (ResourceListener listener : this.listeners) {
                listener.onRootResourceExport(mapping);
            }
        } else {
            for (ResourceListener listener : this.listeners) {
                listener.onSubResourceExport(mapping);
            }
        }
    }

    private ResourceMapping createMapping(String identifier, String root, String path, Method method, Verb verb, Object instance, TransformerPair pair, Set<Role> roles) {
        String methodName = method.getName();
        if (path.length() == 0) {
            path = MethodHelper.convertToPath(methodName);
        }
        String rootPath = ROOT_PATH.equals(path = path.toLowerCase()) ? root.toLowerCase() : root.toLowerCase() + ROOT_PATH + path;
        return new ResourceMapping(identifier, rootPath, path, verb, method, instance, pair, roles);
    }

    private void createRootResource(String identifier, String root, List<ResourceMapping> mappings) throws Fabric3Exception {
        ResourceInvoker invoker = new ResourceInvoker(mappings, this.security);
        List<Method> methods = mappings.stream().map(ResourceMapping::getMethod).collect(Collectors.toList());
        TransformerPair pair = this.pairService.getTransformerPair(methods, (DataType)JSON_INPUT_TYPE, (DataType)JSON_OUTPUT_TYPE);
        root = root.toLowerCase();
        Set<Role> roles = Collections.emptySet();
        ResourceMapping mapping = new ResourceMapping(identifier, root, root, Verb.GET, this.rootResourceMethod, invoker, pair, roles);
        ResourceMapping previous = this.dynamicResources.remove(root);
        if (previous != null) {
            this.resourceHost.unregisterPath(previous.getPath(), Verb.GET);
        }
        this.resourceHost.register(mapping);
        for (ResourceListener listener : this.listeners) {
            listener.onRootResourceExport(mapping);
        }
        this.createDynamicResources(mapping, root, false);
    }

    private void parseRoles(Object instance, Set<Role> readRoles, Set<Role> writeRoles) {
        Management annotation = instance.getClass().getAnnotation(Management.class);
        if (annotation != null) {
            String[] writeRoleNames;
            String[] readRoleNames;
            for (String roleName : readRoleNames = annotation.readRoles()) {
                readRoles.add(new Role(roleName));
            }
            for (String roleName : writeRoleNames = annotation.writeRoles()) {
                writeRoles.add(new Role(roleName));
            }
        }
        if (readRoles.isEmpty()) {
            readRoles.add(new Role("ROLE_FABRIC3_ADMIN"));
            readRoles.add(new Role("ROLE_FABRIC3_OBSERVER"));
        }
        if (writeRoles.isEmpty()) {
            writeRoles.add(new Role("ROLE_FABRIC3_ADMIN"));
        }
    }

    private void createDynamicResources(ResourceMapping mapping, String rootResourcePath, boolean createRootResource) throws Fabric3Exception {
        ResourceMapping previous = this.dynamicResources.remove(mapping.getPath());
        if (previous != null) {
            this.resourceHost.unregisterPath(previous.getPath(), previous.getVerb());
        } else {
            List<ResourceMapping> dynamicMappings = this.createDynamicResourceMappings(mapping, rootResourcePath, createRootResource);
            this.listeners.addAll(dynamicMappings.stream().map(dynamicMapping -> (ResourceListener)dynamicMapping.getInstance()).collect(Collectors.toList()));
            dynamicMappings.stream().filter(dynamicMapping -> !this.resourceHost.isPathRegistered(dynamicMapping.getPath(), dynamicMapping.getVerb())).forEach(dynamicMapping -> {
                this.resourceHost.register((ResourceMapping)dynamicMapping);
                this.notifyExport(dynamicMapping.getRelativePath(), (ResourceMapping)dynamicMapping);
            });
        }
    }

    private List<ResourceMapping> createDynamicResourceMappings(ResourceMapping mapping, String rootResourcePath, boolean createRootResource) {
        String current;
        String path = mapping.getPath();
        ArrayList<ResourceMapping> mappings = new ArrayList<ResourceMapping>();
        while (!(path == null || path.equals(current = PathHelper.getParentPath(path)) || this.dynamicResources.containsKey(current) || this.resourceHost.isPathRegistered(current, Verb.GET))) {
            path = current;
            try {
                if (!createRootResource && current.equals(rootResourcePath)) continue;
                DynamicResourceService resourceService = new DynamicResourceService(current);
                List<Method> list = Collections.singletonList(this.dynamicGetResourceMethod);
                TransformerPair pair = this.pairService.getTransformerPair(list, (DataType)JSON_INPUT_TYPE, (DataType)JSON_OUTPUT_TYPE);
                ResourceMapping dynamicMapping = new ResourceMapping(current, current, ROOT_PATH, Verb.GET, this.dynamicGetResourceMethod, resourceService, pair, mapping.getRoles());
                mappings.add(dynamicMapping);
                this.dynamicResources.put(dynamicMapping.getPath(), dynamicMapping);
            }
            catch (Fabric3Exception e) {
                throw new AssertionError((Object)e);
            }
        }
        Collections.reverse(mappings);
        return mappings;
    }
}

