/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.management.rest.runtime;

import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletRequest;
import org.fabric3.api.Role;
import org.fabric3.api.SecuritySubject;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.management.rest.model.HttpStatus;
import org.fabric3.management.rest.model.Link;
import org.fabric3.management.rest.model.Resource;
import org.fabric3.management.rest.model.ResourceException;
import org.fabric3.management.rest.model.SelfLink;
import org.fabric3.management.rest.runtime.ManagementSecurity;
import org.fabric3.management.rest.spi.ResourceMapping;
import org.fabric3.spi.container.invocation.WorkContext;
import org.fabric3.spi.container.invocation.WorkContextCache;

public class ResourceInvoker {
    List<ResourceMapping> mappings;
    boolean securityCheck;

    public ResourceInvoker(List<ResourceMapping> mappings, ManagementSecurity security) {
        this.mappings = mappings;
        if (security == ManagementSecurity.DISABLED) {
            this.securityCheck = false;
        } else {
            for (ResourceMapping mapping : mappings) {
                if (mapping.getRoles().isEmpty()) continue;
                this.securityCheck = true;
                break;
            }
        }
    }

    public Resource invoke(HttpServletRequest request) throws Fabric3Exception {
        try {
            WorkContext workContext = WorkContextCache.getThreadWorkContext();
            if (workContext == null) {
                throw new AssertionError((Object)"Work context not set");
            }
            this.checkSecurity(workContext);
            URL url = new URL(request.getRequestURL().toString());
            SelfLink selfLink = new SelfLink(url);
            Resource resource = new Resource(selfLink);
            ArrayList<Link> links = new ArrayList<Link>();
            for (ResourceMapping mapping : this.mappings) {
                Object object = this.invoke(mapping);
                String relativePath = mapping.getRelativePath();
                resource.setProperty(relativePath, object);
                URL linkUrl = new URL(request.getRequestURL().append("/").append(relativePath).toString());
                Link link = new Link(relativePath, "edit", linkUrl);
                links.add(link);
            }
            resource.setProperty("links", links);
            return resource;
        }
        catch (MalformedURLException e) {
            throw new Fabric3Exception((Throwable)e);
        }
    }

    private void checkSecurity(WorkContext workContext) throws ResourceException {
        if (this.securityCheck) {
            SecuritySubject subject = workContext.getSubject();
            if (subject == null) {
                throw new ResourceException(HttpStatus.UNAUTHORIZED, "Unauthorized");
            }
            for (ResourceMapping mapping : this.mappings) {
                boolean found = false;
                for (Role role : mapping.getRoles()) {
                    if (!subject.getRoles().contains(role)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                throw new ResourceException(HttpStatus.UNAUTHORIZED, "Unauthorized");
            }
        }
    }

    private Object invoke(ResourceMapping mapping) throws Fabric3Exception {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Object instance = mapping.getInstance();
            if (instance instanceof Supplier) {
                instance = ((Supplier)instance).get();
            }
            Thread.currentThread().setContextClassLoader(instance.getClass().getClassLoader());
            Object object = mapping.getMethod().invoke(instance, new Object[0]);
            return object;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException | Fabric3Exception e) {
            throw new Fabric3Exception("Error invoking operation: " + mapping.getMethod(), e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }
}

