/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.management.rest.runtime;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.fabric3.api.Role;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.management.rest.model.HttpStatus;
import org.fabric3.management.rest.model.ResourceException;
import org.fabric3.management.rest.model.Response;
import org.fabric3.management.rest.runtime.BasicAuthenticator;
import org.fabric3.management.rest.runtime.ManagementMonitor;
import org.fabric3.management.rest.runtime.ManagementSecurity;
import org.fabric3.management.rest.runtime.Marshaller;
import org.fabric3.management.rest.runtime.PathHelper;
import org.fabric3.management.rest.spi.ResourceHost;
import org.fabric3.management.rest.spi.ResourceMapping;
import org.fabric3.management.rest.spi.Verb;
import org.fabric3.spi.container.invocation.WorkContext;
import org.fabric3.spi.container.invocation.WorkContextCache;
import org.fabric3.spi.host.ServletHost;
import org.fabric3.spi.security.AuthenticationException;
import org.fabric3.spi.security.NoCredentialsException;
import org.fabric3.spi.transform.Transformer;
import org.oasisopen.sca.annotation.Destroy;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Property;
import org.oasisopen.sca.annotation.Reference;

public class ResourceHostImpl
extends HttpServlet
implements ResourceHost {
    private static final long serialVersionUID = 5554150494161533656L;
    private static final String MANAGEMENT_PATH = "/management/*";
    private Marshaller marshaller;
    private ServletHost servletHost;
    private BasicAuthenticator authenticator;
    private ManagementMonitor monitor;
    private ManagementSecurity security = ManagementSecurity.DISABLED;
    private Set<Role> roles = new HashSet<Role>();
    private boolean disableHttp;
    private Map<String, ResourceMapping> getMappings = new ConcurrentHashMap<String, ResourceMapping>();
    private Map<String, ResourceMapping> postMappings = new ConcurrentHashMap<String, ResourceMapping>();
    private Map<String, ResourceMapping> putMappings = new ConcurrentHashMap<String, ResourceMapping>();
    private Map<String, ResourceMapping> deleteMappings = new ConcurrentHashMap<String, ResourceMapping>();
    private Map<String, List<ResourceMapping>> registered = new ConcurrentHashMap<String, List<ResourceMapping>>();

    public ResourceHostImpl(@Reference Marshaller marshaller, @Reference ServletHost servletHost, @Reference BasicAuthenticator authenticator, @Monitor ManagementMonitor monitor) {
        this.marshaller = marshaller;
        this.servletHost = servletHost;
        this.authenticator = authenticator;
        this.monitor = monitor;
    }

    @Property(required=false)
    public void setSecurity(String level) throws Fabric3Exception {
        try {
            this.security = ManagementSecurity.valueOf(level.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new Fabric3Exception("Invalid management security setting:" + level);
        }
    }

    @Property(required=false)
    public void setRoles(String rolesAttribute) {
        String[] rolesString;
        for (String s : rolesString = rolesAttribute.split(",")) {
            this.roles.add(new Role(s.trim()));
        }
    }

    @Property(required=false)
    public void setDisableHttp(boolean disableHttp) {
        this.disableHttp = disableHttp;
    }

    @Init
    public void start() throws Fabric3Exception {
        this.servletHost.registerMapping(MANAGEMENT_PATH, (Servlet)this);
        if (ManagementSecurity.DISABLED == this.security) {
            this.monitor.securityDisabled();
        }
        if (!this.disableHttp) {
            this.monitor.httpEnabled();
        }
    }

    @Destroy
    public void stop() throws Fabric3Exception {
        this.servletHost.unregisterMapping(MANAGEMENT_PATH);
    }

    public void init() {
    }

    @Override
    public boolean isPathRegistered(String path, Verb verb) {
        if (verb == Verb.GET) {
            return this.getMappings.containsKey(path);
        }
        if (verb == Verb.POST) {
            return this.postMappings.containsKey(path);
        }
        if (verb == Verb.PUT) {
            return this.putMappings.containsKey(path);
        }
        return verb == Verb.DELETE && this.deleteMappings.containsKey(path);
    }

    @Override
    public void register(ResourceMapping mapping) throws Fabric3Exception {
        Verb verb = mapping.getVerb();
        if (verb == Verb.GET) {
            this.register(mapping, this.getMappings);
        } else if (verb == Verb.POST) {
            this.register(mapping, this.postMappings);
        } else if (verb == Verb.PUT) {
            this.register(mapping, this.putMappings);
        } else if (verb == Verb.DELETE) {
            this.register(mapping, this.deleteMappings);
        }
    }

    @Override
    public void unregister(String identifier) {
        List<ResourceMapping> list = this.registered.remove(identifier);
        if (list == null) {
            return;
        }
        for (ResourceMapping mapping : list) {
            String path = mapping.getPath();
            Verb verb = mapping.getVerb();
            if (verb == Verb.GET) {
                this.getMappings.remove(path);
                continue;
            }
            if (verb == Verb.POST) {
                this.postMappings.remove(path);
                continue;
            }
            if (verb == Verb.PUT) {
                this.putMappings.remove(path);
                continue;
            }
            if (verb != Verb.DELETE) continue;
            this.deleteMappings.remove(path);
        }
    }

    @Override
    public void unregisterPath(String path, Verb verb) {
        ResourceMapping mapping = verb == Verb.GET ? this.getMappings.remove(path) : (verb == Verb.POST ? this.postMappings.remove(path) : (verb == Verb.PUT ? this.putMappings.remove(path) : this.deleteMappings.remove(path)));
        if (mapping != null) {
            String identifier = mapping.getIdentifier();
            List<ResourceMapping> mappings = this.registered.get(identifier);
            mappings.remove(mapping);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatch(String path, Verb verb, Object[] params) {
        ResourceMapping mapping = this.resolveMapping(verb, path);
        if (mapping == null) {
            this.monitor.error("Mapping not found during zone broadcast: " + path);
            return;
        }
        WorkContext workContext = WorkContextCache.getAndResetThreadWorkContext();
        try {
            this.invoke(mapping, params);
        }
        catch (ResourceException e) {
            this.monitor.error("Error replicating resource request: " + mapping.getMethod(), (Throwable)((Object)e));
        }
        finally {
            workContext.reset();
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        this.handle(Verb.GET, request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        this.handle(Verb.POST, request, response);
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) {
        this.handle(Verb.DELETE, request, response);
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) {
        this.handle(Verb.PUT, request, response);
    }

    private void register(ResourceMapping mapping, Map<String, ResourceMapping> mappings) throws Fabric3Exception {
        String path = mapping.getPath();
        if (mappings.containsKey(path)) {
            throw new Fabric3Exception("Resource already registered at: " + path);
        }
        String identifier = mapping.getIdentifier();
        List<ResourceMapping> registered = this.getRegistered(identifier);
        registered.add(mapping);
        mappings.put(path, mapping);
    }

    private List<ResourceMapping> getRegistered(String name) {
        List<ResourceMapping> list = this.registered.get(name);
        if (list == null) {
            list = new ArrayList<ResourceMapping>();
            this.registered.put(name, list);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handle(Verb verb, HttpServletRequest request, HttpServletResponse response) {
        if (this.disableHttp && !request.isSecure()) {
            response.setStatus(HttpStatus.FORBIDDEN.getCode());
            try {
                response.getWriter().write("Forbidden. Only HTTPS access is allowed");
            }
            catch (IOException e) {
                this.monitor.error("Error writing response");
            }
            return;
        }
        if (request.getPathInfo() == null) {
            response.setStatus(HttpStatus.NOT_FOUND.getCode());
            return;
        }
        String pathInfo = this.parsePathInfo(request);
        ResourceMapping mapping = this.resolveMapping(verb, pathInfo);
        if (mapping == null) {
            response.setStatus(404);
            try {
                response.getWriter().print("Management resource not found");
            }
            catch (IOException e) {
                this.monitor.error("Error writing response", e);
            }
            return;
        }
        WorkContext workContext = WorkContextCache.getAndResetThreadWorkContext();
        try {
            if (!this.securityCheck(mapping, request, response, workContext)) {
                return;
            }
            Object[] params = this.marshaller.deserialize(verb, request, mapping);
            Object value = this.invoke(mapping, params);
            this.respond(value, mapping, request, response);
        }
        catch (ResourceException e) {
            this.respondError(e, mapping, response);
        }
        finally {
            workContext.reset();
        }
    }

    private String parsePathInfo(HttpServletRequest request) {
        String pathInfo = request.getPathInfo().toLowerCase();
        if (pathInfo.endsWith("/")) {
            pathInfo = pathInfo.substring(0, pathInfo.length() - 1);
        }
        if (pathInfo.startsWith("/management/")) {
            pathInfo = pathInfo.substring(11);
        }
        return pathInfo;
    }

    private ResourceMapping resolveMapping(Verb verb, String path) {
        ResourceMapping mapping = verb == Verb.GET ? this.resolve(path, this.getMappings) : (verb == Verb.POST ? this.resolve(path, this.postMappings) : (verb == Verb.PUT ? this.resolve(path, this.putMappings) : this.resolve(path, this.deleteMappings)));
        return mapping;
    }

    private ResourceMapping resolve(String path, Map<String, ResourceMapping> mappings) {
        boolean start = true;
        while (path != null) {
            ResourceMapping mapping = mappings.get(path);
            if (mapping != null && (start || mapping.isParameterized())) {
                return mapping;
            }
            start = false;
            String current = PathHelper.getParentPath(path);
            if (path.equals(current)) break;
            path = current;
        }
        return null;
    }

    private boolean securityCheck(ResourceMapping mapping, HttpServletRequest request, HttpServletResponse response, WorkContext workContext) {
        if (ManagementSecurity.DISABLED == this.security) {
            return true;
        }
        try {
            this.authenticator.authenticate(request, workContext);
        }
        catch (NoCredentialsException e) {
            response.setStatus(HttpStatus.UNAUTHORIZED.getCode());
            response.setHeader("WWW-Authenticate", "Basic realm=\"fabric3\"");
            return false;
        }
        catch (AuthenticationException e) {
            this.setUnauthorizedResponse(response);
            return false;
        }
        if (ManagementSecurity.AUTHORIZATION == this.security) {
            if (!this.checkSubjectHasRole(workContext, this.roles)) {
                this.setUnauthorizedResponse(response);
                return false;
            }
            if (!this.checkSubjectHasRole(workContext, mapping.getRoles())) {
                this.setUnauthorizedResponse(response);
                return false;
            }
        }
        return true;
    }

    private boolean checkSubjectHasRole(WorkContext workContext, Set<Role> roles) {
        if (roles.isEmpty()) {
            return true;
        }
        boolean authorized = false;
        for (Role role : workContext.getSubject().getRoles()) {
            if (!roles.contains(role)) continue;
            authorized = true;
            break;
        }
        return authorized;
    }

    private void setUnauthorizedResponse(HttpServletResponse response) {
        response.setStatus(HttpStatus.UNAUTHORIZED.getCode());
        try {
            response.getWriter().write("Unauthorized");
        }
        catch (IOException e) {
            this.monitor.error("Error writing response", e);
        }
    }

    private Object invoke(ResourceMapping mapping, Object[] params) throws ResourceException {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        try {
            Object instance = mapping.getInstance();
            if (instance instanceof Supplier) {
                instance = ((Supplier)instance).get();
            }
            Thread.currentThread().setContextClassLoader(instance.getClass().getClassLoader());
            Object object = mapping.getMethod().invoke(instance, params);
            return object;
        }
        catch (IllegalAccessException | Fabric3Exception e) {
            this.monitor.error("Error invoking operation: " + mapping.getMethod(), e);
            throw new ResourceException(HttpStatus.INTERNAL_SERVER_ERROR);
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            if (target instanceof ResourceException) {
                throw (ResourceException)((Object)target);
            }
            this.monitor.error("Error invoking operation: " + mapping.getMethod(), e);
            throw new ResourceException(HttpStatus.INTERNAL_SERVER_ERROR);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    private void respond(Object value, ResourceMapping mapping, HttpServletRequest request, HttpServletResponse response) throws ResourceException {
        response.setContentType("application/json");
        if (value instanceof Response) {
            Response resourceResponse = (Response)value;
            for (Map.Entry<String, String> entry : resourceResponse.getHeaders().entrySet()) {
                response.setHeader(entry.getKey(), entry.getValue());
            }
            response.setStatus(resourceResponse.getStatus().getCode());
            Object entity = resourceResponse.getEntity();
            if (entity != null) {
                this.marshaller.serialize(entity, mapping, request, response);
            }
        } else if (value != null) {
            this.marshaller.serialize(value, mapping, request, response);
        }
    }

    private void respondError(ResourceException e, ResourceMapping mapping, HttpServletResponse response) {
        response.setContentType("application/json");
        for (Map.Entry<String, String> entry : e.getHeaders().entrySet()) {
            response.setHeader(entry.getKey(), entry.getValue());
        }
        response.setStatus(e.getStatus().getCode());
        try {
            String message = e.getMessage();
            Object entity = e.getEntity();
            if (entity != null) {
                Transformer<Object, byte[]> transformer = mapping.getPair().getSerializer();
                byte[] serialized = (byte[])transformer.transform(entity, entity.getClass().getClassLoader());
                response.getOutputStream().write(serialized);
            } else if (message != null) {
                Transformer<Object, byte[]> transformer = mapping.getPair().getSerializer();
                byte[] serialized = (byte[])transformer.transform((Object)message, this.getClass().getClassLoader());
                response.getOutputStream().write(serialized);
            }
        }
        catch (IOException ex) {
            this.monitor.error("Cannot write error response", ex);
            this.monitor.error("Response was ", (Throwable)((Object)e));
        }
        catch (Fabric3Exception ex) {
            this.monitor.error("Cannot serialize error response", ex);
            this.monitor.error("Response was ", (Throwable)((Object)e));
        }
    }
}

