/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.management.rest.runtime;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.management.rest.model.HttpStatus;
import org.fabric3.management.rest.model.Resource;
import org.fabric3.management.rest.model.ResourceException;
import org.fabric3.management.rest.model.SelfLink;
import org.fabric3.management.rest.runtime.ManagementMonitor;
import org.fabric3.management.rest.runtime.Marshaller;
import org.fabric3.management.rest.spi.ResourceMapping;
import org.fabric3.management.rest.spi.Verb;
import org.fabric3.spi.transform.Transformer;

public class MarshallerImpl
implements Marshaller {
    private ManagementMonitor monitor;

    public MarshallerImpl(@Monitor ManagementMonitor monitor) {
        this.monitor = monitor;
    }

    @Override
    public Object[] deserialize(Verb verb, HttpServletRequest request, ResourceMapping mapping) throws ResourceException {
        Object[] params = null;
        Class<?>[] types = mapping.getMethod().getParameterTypes();
        if (types.length > 0) {
            if (verb == Verb.GET || verb == Verb.DELETE) {
                params = this.deserializeUrlParams(request, mapping);
            } else if (verb == Verb.PUT | verb == Verb.POST) {
                params = this.deserializeInputStream(request, mapping);
            }
        }
        return params;
    }

    @Override
    public void serialize(Object value, ResourceMapping mapping, HttpServletRequest request, HttpServletResponse response) throws ResourceException {
        ClassLoader loader = mapping.getInstance().getClass().getClassLoader();
        try {
            URL url;
            Resource resource;
            if (value instanceof Resource) {
                resource = (Resource)value;
                if (resource.getSelfLink() == null) {
                    url = new URL(request.getRequestURL().toString());
                    SelfLink link = new SelfLink(url);
                    resource.setSelfLink(link);
                }
            } else {
                url = new URL(request.getRequestURL().toString());
                SelfLink link = new SelfLink(url);
                resource = new Resource(link);
                resource.setProperty("value", value);
            }
            byte[] output = (byte[])mapping.getPair().getSerializer().transform((Object)resource, loader);
            response.getOutputStream().write(output);
        }
        catch (Fabric3Exception e) {
            Method method = mapping.getMethod();
            this.monitor.error("Error serializing response for " + method, e);
            throw new ResourceException(HttpStatus.INTERNAL_SERVER_ERROR);
        }
        catch (MalformedURLException e) {
            this.monitor.error("Error creating URL for " + request.getRequestURL(), e);
            throw new ResourceException(HttpStatus.INTERNAL_SERVER_ERROR);
        }
        catch (IOException e) {
            this.monitor.error("Error opening response output stream", e);
            throw new ResourceException(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private Object[] deserializeUrlParams(HttpServletRequest request, ResourceMapping mapping) throws ResourceException {
        Method method = mapping.getMethod();
        Class<?>[] types = method.getParameterTypes();
        if (types.length == 1 && HttpServletRequest.class.isAssignableFrom(types[0])) {
            return new Object[]{request};
        }
        if (types.length == 1) {
            StringBuffer requestUrl = request.getRequestURL();
            int pos = requestUrl.lastIndexOf("/");
            if (pos < 0) {
                throw new ResourceException(HttpStatus.BAD_REQUEST, "Expected parameterized URL: " + requestUrl);
            }
            String value = requestUrl.substring(pos + 1);
            if (value.length() == 0) {
                throw new ResourceException(HttpStatus.BAD_REQUEST, "Parameter must be specified: " + requestUrl);
            }
            try {
                Object deserialized = this.deserialize(value, method);
                return new Object[]{deserialized};
            }
            catch (IOException e) {
                this.monitor.error("Error deserializing parameters for " + method, e);
                throw new ResourceException(HttpStatus.BAD_REQUEST, "Invalid or unsupported parameter type");
            }
        }
        throw new ResourceException(HttpStatus.BAD_REQUEST, "Multiple parameter types not supported: " + method);
    }

    private Object[] deserializeInputStream(HttpServletRequest request, ResourceMapping mapping) throws ResourceException {
        Method method = mapping.getMethod();
        Class<?>[] types = method.getParameterTypes();
        if (types.length == 1 && HttpServletRequest.class.isAssignableFrom(types[0])) {
            return new Object[]{request};
        }
        if (types.length == 1) {
            if (!"application/json".equals(request.getContentType())) {
                throw new ResourceException(HttpStatus.BAD_REQUEST, "Content type not supported: " + request.getContentType());
            }
            Transformer<InputStream, Object> transformer = mapping.getPair().getDeserializer();
            try {
                ClassLoader loader = mapping.getInstance().getClass().getClassLoader();
                ServletInputStream stream = request.getInputStream();
                return new Object[]{transformer.transform((Object)stream, loader)};
            }
            catch (Fabric3Exception e) {
                this.monitor.error("Error deserializing parameters for " + method, e);
                throw new ResourceException(HttpStatus.BAD_REQUEST, "Invalid or unsupported parameter type");
            }
            catch (IOException e) {
                this.monitor.error("Error opening request input stream", e);
                throw new ResourceException(HttpStatus.INTERNAL_SERVER_ERROR, "Error reading request");
            }
        }
        throw new ResourceException(HttpStatus.BAD_REQUEST, "Multiple parameter types not supported: " + method);
    }

    Object deserialize(String value, Method method) throws IOException {
        if (method.getParameterTypes().length != 1) {
            throw new IOException("Invalid number of parameters: " + method);
        }
        Class<?> type = method.getParameterTypes()[0];
        if (String.class.equals(type)) {
            return value;
        }
        if (Integer.class.equals(type) || Integer.TYPE.equals(type)) {
            return Integer.parseInt(value);
        }
        if (Long.class.equals(type) || Long.TYPE.equals(type)) {
            return Long.parseLong(value);
        }
        if (Double.class.equals(type) || Double.TYPE.equals(type)) {
            return Double.parseDouble(value);
        }
        if (Short.class.equals(type) || Short.TYPE.equals(type)) {
            return Short.parseShort(value);
        }
        if (Float.class.equals(type) || Float.TYPE.equals(type)) {
            return Float.valueOf(Float.parseFloat(value));
        }
        throw new IOException("Unsupported parameter type: " + method);
    }
}

