/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.management.rest.framework.runtime;

import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import org.fabric3.api.annotation.management.Management;
import org.fabric3.api.annotation.management.ManagementOperation;
import org.fabric3.api.host.runtime.HostInfo;
import org.fabric3.api.model.type.RuntimeMode;
import org.fabric3.management.rest.framework.AbstractResourceService;
import org.fabric3.management.rest.model.Resource;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
@Management(path="/runtime")
public class RuntimeResourceService
extends AbstractResourceService {
    private static final String RUNTIME_PATH = "/runtime";
    private HostInfo info;

    public RuntimeResourceService(@Reference HostInfo info) {
        this.info = info;
    }

    @Override
    protected String getResourcePath() {
        return RUNTIME_PATH;
    }

    @Override
    protected void populateResource(Resource resource, HttpServletRequest request) {
        resource.setProperty("name", this.getName());
        resource.setProperty("domain", this.getDomain());
        resource.setProperty("mode", this.getMode());
    }

    @ManagementOperation(description="The runtime name")
    public String getName() {
        return this.info.getRuntimeName();
    }

    @ManagementOperation(description="The domain URI this runtime is a part of ")
    public URI getDomain() {
        return this.info.getDomain();
    }

    @ManagementOperation(description="The runtime mode")
    public RuntimeMode getMode() {
        return this.info.getRuntimeMode();
    }
}

