/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.management.rest.framework.domain.deployment;

import java.net.URI;
import java.util.ArrayList;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.fabric3.api.annotation.management.Management;
import org.fabric3.api.annotation.management.ManagementOperation;
import org.fabric3.management.rest.framework.ResourceHelper;
import org.fabric3.management.rest.model.Resource;
import org.fabric3.management.rest.model.SelfLink;
import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.contribution.ContributionState;
import org.fabric3.spi.contribution.MetaDataStore;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
@Management(path="/domain/deployments")
public class DeploymentsResourceService {
    private MetaDataStore store;

    public DeploymentsResourceService(@Reference MetaDataStore store) {
        this.store = store;
    }

    @ManagementOperation(path="/")
    public Resource getDeployments(HttpServletRequest request) {
        SelfLink selfLink = ResourceHelper.createSelfLink(request);
        Resource resource = new Resource(selfLink);
        Set contributions = this.store.getContributions();
        ArrayList<URI> list = new ArrayList<URI>();
        for (Contribution contribution : contributions) {
            if (contribution.getState() != ContributionState.DEPLOYED || contribution.getManifest().isExtension()) continue;
            URI uri = contribution.getUri();
            list.add(uri);
        }
        resource.setProperty("contributions", list);
        return resource;
    }
}

