/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.management.rest.framework.domain.contribution;

import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import org.fabric3.api.annotation.management.Management;
import org.fabric3.api.annotation.management.ManagementOperation;
import org.fabric3.api.host.contribution.Deployable;
import org.fabric3.management.rest.framework.ResourceHelper;
import org.fabric3.management.rest.framework.domain.contribution.ContributionResource;
import org.fabric3.management.rest.framework.domain.contribution.ContributionStatus;
import org.fabric3.management.rest.model.HttpStatus;
import org.fabric3.management.rest.model.Link;
import org.fabric3.management.rest.model.Resource;
import org.fabric3.management.rest.model.ResourceException;
import org.fabric3.management.rest.model.SelfLink;
import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.contribution.MetaDataStore;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
@Management(path="/domain/contributions")
public class ContributionsResourceService {
    private MetaDataStore store;

    public ContributionsResourceService(@Reference MetaDataStore store) {
        this.store = store;
    }

    @ManagementOperation(path="/")
    public Resource getContributions(HttpServletRequest request) {
        SelfLink selfLink = ResourceHelper.createSelfLink(request);
        Resource resource = new Resource(selfLink);
        Set contributions = this.store.getContributions();
        ArrayList<ContributionStatus> list = new ArrayList<ContributionStatus>();
        for (Contribution contribution : contributions) {
            URI uri = contribution.getUri();
            Link link = this.createContributionLink(uri, request);
            String state = contribution.getState().toString();
            ContributionStatus status = new ContributionStatus(uri, state, link);
            list.add(status);
        }
        resource.setProperty("contributions", list);
        return resource;
    }

    @ManagementOperation(path="contribution")
    public ContributionResource getContribution(String uri) throws ResourceException {
        URI contributionUri = URI.create(uri);
        Contribution contribution = this.store.find(contributionUri);
        if (contribution == null) {
            throw new ResourceException(HttpStatus.NOT_FOUND, "Contribution not found: " + uri);
        }
        String state = contribution.getState().toString();
        List deployables = contribution.getManifest().getDeployables();
        ArrayList<QName> names = new ArrayList<QName>();
        for (Deployable deployable : deployables) {
            QName name = deployable.getName();
            names.add(name);
        }
        return new ContributionResource(contributionUri, state, names);
    }

    private Link createContributionLink(URI contributionUri, HttpServletRequest request) {
        String uri = contributionUri.toString();
        String requestUrl = ResourceHelper.getRequestUrl(request);
        URL url = ResourceHelper.createUrl(requestUrl + "/contribution/" + uri);
        return new Link(uri, "edit", url);
    }
}

