/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.datasource.runtime;

import java.util.function.Supplier;
import javax.sql.DataSource;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.datasource.provision.DataSourceWireTarget;
import org.fabric3.datasource.spi.DataSourceRegistry;
import org.fabric3.spi.container.builder.TargetWireAttacher;
import org.oasisopen.sca.annotation.Reference;

public class DataSourceWireAttacher
implements TargetWireAttacher<DataSourceWireTarget> {
    private DataSourceRegistry registry;

    public DataSourceWireAttacher(@Reference DataSourceRegistry registry) {
        this.registry = registry;
    }

    public Supplier<DataSource> createSupplier(DataSourceWireTarget target) {
        String dataSourceName = target.getDataSourceName();
        DataSource source = this.registry.getDataSource(dataSourceName);
        if (!target.isOptional() && source == null) {
            throw new Fabric3Exception("DataSource not found: " + dataSourceName);
        }
        return () -> source;
    }
}

