/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.datasource.introspection;

import java.lang.reflect.Member;
import javax.sql.DataSource;
import org.fabric3.api.annotation.Resource;
import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.api.model.type.component.ComponentType;
import org.fabric3.api.model.type.contract.ServiceContract;
import org.fabric3.api.model.type.java.InjectingComponentType;
import org.fabric3.datasource.introspection.MissingDataSourceName;
import org.fabric3.datasource.model.DataSourceResourceReference;
import org.fabric3.resource.spi.ResourceTypeHandler;
import org.fabric3.spi.introspection.DefaultIntrospectionContext;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.java.contract.JavaContractProcessor;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class JSR250DataSourceTypeHandler
implements ResourceTypeHandler {
    private ServiceContract contract;
    private JavaContractProcessor contractProcessor;

    public JSR250DataSourceTypeHandler(@Reference JavaContractProcessor contractProcessor) {
        this.contractProcessor = contractProcessor;
    }

    @Init
    public void init() {
        this.contract = this.contractProcessor.introspect(DataSource.class, (IntrospectionContext)new DefaultIntrospectionContext(), new ModelObject[0]);
    }

    public DataSourceResourceReference createResourceReference(String resourceName, Resource annotation, Member member, InjectingComponentType componentType, IntrospectionContext context) {
        String dataSourceName = annotation.name();
        if (dataSourceName.length() == 0) {
            MissingDataSourceName error = new MissingDataSourceName(member, (ComponentType)componentType);
            context.addError((ValidationFailure)error);
            return new DataSourceResourceReference(resourceName, this.contract, annotation.optional(), "error");
        }
        return new DataSourceResourceReference(resourceName, this.contract, annotation.optional(), dataSourceName);
    }
}

