/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.runtime.bootstrap;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.host.stream.Source;
import org.fabric3.api.host.stream.UrlSource;
import org.fabric3.api.model.type.RuntimeMode;
import org.fabric3.fabric.xml.DocumentLoader;
import org.fabric3.fabric.xml.DocumentLoaderImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class SystemConfigLoader {
    private static final URI DEFAULT_DOMAIN = URI.create("fabric3://domain");
    private DocumentLoader loader = new DocumentLoaderImpl();

    public Document loadSystemConfig(File configDirectory) throws Fabric3Exception {
        File systemConfig = new File(configDirectory, "systemConfig.xml");
        if (systemConfig.exists()) {
            try {
                URL url = systemConfig.toURI().toURL();
                UrlSource source = new UrlSource(url);
                return this.loadSystemConfig((Source)source);
            }
            catch (MalformedURLException e) {
                throw new Fabric3Exception((Throwable)e);
            }
        }
        return this.createDefaultSystemConfig();
    }

    public Document loadSystemConfig(Source source) throws Fabric3Exception {
        InputSource inputSource = new InputSource(source.openStream());
        Document document = this.loader.load(inputSource, true);
        Element oldRoot = document.getDocumentElement();
        boolean hasNamespaces = oldRoot.getNamespaceURI() != null && !"".equals(oldRoot.getNamespaceURI());
        Element newRoot = document.createElementNS("urn:fabric3.org", "values");
        newRoot.setAttribute("xmlns:sca", "http://docs.oasis-open.org/ns/opencsa/sca/200912");
        document.removeChild(oldRoot);
        document.appendChild(newRoot);
        newRoot.appendChild(oldRoot);
        if (!hasNamespaces) {
            this.loader.addNamespace(document, oldRoot, "urn:fabric3.org");
        }
        return document;
    }

    public Document createDefaultSystemConfig() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            Document document = factory.newDocumentBuilder().newDocument();
            Element root = document.createElement("values");
            document.appendChild(root);
            Element config = document.createElement("config");
            root.appendChild(config);
            return document;
        }
        catch (ParserConfigurationException e) {
            throw new AssertionError((Object)e);
        }
    }

    public URI parseDomainName(Document systemConfig) throws Fabric3Exception {
        Element root = systemConfig.getDocumentElement();
        NodeList nodes = root.getElementsByTagName("runtime");
        if (nodes.getLength() == 1) {
            Element node = (Element)nodes.item(0);
            String name = node.getAttribute("domain");
            if (name.length() > 0) {
                try {
                    URI uri = new URI("fabric3://" + name);
                    if (uri.getHost() == null) {
                        throw new Fabric3Exception("Invalid domain name specified in system configuration. Domain names must be a valid URI host.");
                    }
                    return uri;
                }
                catch (URISyntaxException e) {
                    throw new Fabric3Exception("Invalid domain name specified in system configuration", (Throwable)e);
                }
            }
            return DEFAULT_DOMAIN;
        }
        if (nodes.getLength() == 0) {
            return DEFAULT_DOMAIN;
        }
        throw new Fabric3Exception("Invalid system configuration: more than one <runtime> element specified");
    }

    public String parseProductName(Document systemConfig) throws Fabric3Exception {
        Element root = systemConfig.getDocumentElement();
        NodeList nodes = root.getElementsByTagName("runtime");
        if (nodes.getLength() == 1) {
            Element node = (Element)nodes.item(0);
            String name = node.getAttribute("product");
            if (name.length() > 0) {
                return name;
            }
            return "Fabric3";
        }
        if (nodes.getLength() == 0) {
            return "Fabric3";
        }
        throw new Fabric3Exception("Invalid system configuration: more than one <runtime> element specified");
    }

    public String parseZoneName(Document systemConfig, RuntimeMode mode) throws Fabric3Exception {
        if (RuntimeMode.VM == mode) {
            return "LocalZone";
        }
        Element root = systemConfig.getDocumentElement();
        NodeList nodes = root.getElementsByTagName("zoneName");
        if (nodes.getLength() == 1) {
            Element node = (Element)nodes.item(0);
            String name = node.getTextContent();
            if (name != null) {
                name = name.trim();
            }
            return name;
        }
        if (nodes.getLength() == 0) {
            return "default.zone";
        }
        throw new Fabric3Exception("Invalid system configuration: more than one <runtime> element specified");
    }

    public RuntimeMode parseRuntimeMode(Document systemConfig) throws Fabric3Exception {
        Element node;
        String name;
        Element root = systemConfig.getDocumentElement();
        NodeList nodes = root.getElementsByTagName("runtime");
        if (nodes.getLength() == 1 && "node".equalsIgnoreCase(name = (node = (Element)nodes.item(0)).getAttribute("mode"))) {
            return RuntimeMode.NODE;
        }
        return RuntimeMode.VM;
    }

    public String parseEnvironment(Document systemConfig) {
        Element node;
        String environment;
        Element root = systemConfig.getDocumentElement();
        NodeList nodes = root.getElementsByTagName("runtime");
        if (nodes.getLength() == 1 && (environment = (node = (Element)nodes.item(0)).getAttribute("environment")).length() > 0) {
            return environment;
        }
        return "production";
    }

    public List<File> parseDeployDirectories(Document systemConfig) {
        ArrayList<File> files = new ArrayList<File>();
        Element root = systemConfig.getDocumentElement();
        NodeList nodes = root.getElementsByTagName("deploy.directory");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element element = (Element)nodes.item(i);
            File file = new File(element.getTextContent());
            files.add(file);
        }
        return files;
    }
}

