/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.runtime;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.host.Names;
import org.fabric3.api.host.contribution.ContributionOrder;
import org.fabric3.api.host.contribution.ContributionService;
import org.fabric3.api.host.domain.Domain;
import org.fabric3.api.host.runtime.BootConfiguration;
import org.fabric3.api.host.runtime.Fabric3Runtime;
import org.fabric3.api.host.runtime.HostInfo;
import org.fabric3.api.host.runtime.RuntimeCoordinator;
import org.fabric3.api.host.runtime.RuntimeState;
import org.fabric3.fabric.runtime.DefaultBootstrapper;
import org.fabric3.spi.runtime.event.EventService;
import org.fabric3.spi.runtime.event.ExtensionsInitialized;
import org.fabric3.spi.runtime.event.Fabric3Event;
import org.fabric3.spi.runtime.event.JoinDomain;
import org.fabric3.spi.runtime.event.JoinDomainCompleted;
import org.fabric3.spi.runtime.event.RuntimeDestroyed;
import org.fabric3.spi.runtime.event.RuntimeRecover;
import org.fabric3.spi.runtime.event.RuntimeStart;
import org.fabric3.spi.runtime.event.RuntimeStop;
import org.fabric3.spi.runtime.event.TransportStart;
import org.fabric3.spi.runtime.event.TransportStop;

public class DefaultCoordinator
implements RuntimeCoordinator {
    private RuntimeState state = RuntimeState.UNINITIALIZED;
    private BootConfiguration configuration;
    private Fabric3Runtime runtime;

    public DefaultCoordinator(BootConfiguration configuration) {
        this.configuration = configuration;
        this.runtime = configuration.getRuntime();
    }

    public RuntimeState getState() {
        return this.state;
    }

    public void start() throws Fabric3Exception {
        this.boot();
        this.load();
        this.startRuntime();
        this.startTransports();
    }

    public void boot() throws Fabric3Exception {
        this.runtime.boot();
        DefaultBootstrapper bootstrapper = new DefaultBootstrapper(this.configuration);
        bootstrapper.bootRuntimeDomain();
        bootstrapper.bootSystem();
    }

    public void load() throws Fabric3Exception {
        this.loadExtensions();
        EventService eventService = (EventService)this.runtime.getComponent(EventService.class);
        eventService.publish((Fabric3Event)new ExtensionsInitialized());
        this.recover(eventService);
    }

    public void startRuntime() {
        EventService eventService = (EventService)this.runtime.getComponent(EventService.class);
        eventService.publish((Fabric3Event)new JoinDomain());
        eventService.publish((Fabric3Event)new JoinDomainCompleted());
        eventService.publish((Fabric3Event)new RuntimeStart());
        this.state = RuntimeState.STARTED;
        ((HostInfo)this.runtime.getComponent(HostInfo.class)).notifyCallbacks();
    }

    public void startTransports() {
        EventService eventService = (EventService)this.runtime.getComponent(EventService.class);
        eventService.publish((Fabric3Event)new TransportStart());
        this.state = RuntimeState.RUNNING;
    }

    public void shutdown() throws Fabric3Exception {
        if (this.state == RuntimeState.RUNNING) {
            EventService eventService = (EventService)this.runtime.getComponent(EventService.class);
            eventService.publish((Fabric3Event)new TransportStop());
            eventService.publish((Fabric3Event)new RuntimeStop());
            RuntimeDestroyed destroyed = new RuntimeDestroyed();
            this.runtime.destroy();
            eventService.publish((Fabric3Event)destroyed);
        }
        this.state = RuntimeState.SHUTDOWN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadExtensions() throws Fabric3Exception {
        List contributions = this.configuration.getExtensionContributions();
        ContributionService contributionService = (ContributionService)this.runtime.getComponent(ContributionService.class);
        Domain domain = (Domain)this.runtime.getComponent(Domain.class, Names.RUNTIME_DOMAIN_SERVICE_URI);
        try {
            ContributionOrder order = contributionService.processManifests(contributions);
            order.getBootstrapContributions().forEach(arg_0 -> ((ContributionService)contributionService).processContents(arg_0));
            domain.include(order.getBootstrapContributions());
            order.getBaseContributions().forEach(arg_0 -> ((ContributionService)contributionService).processContents(arg_0));
            domain.include(order.getBaseContributions());
            for (URI uri : order.getIsolatedContributions()) {
                contributionService.processContents(uri);
                domain.include(Collections.singletonList(uri));
            }
        }
        finally {
            this.state = RuntimeState.ERROR;
        }
    }

    private void recover(EventService eventService) throws Fabric3Exception {
        Domain domain = (Domain)this.runtime.getComponent(Domain.class, Names.APPLICATION_DOMAIN_URI);
        if (domain == null) {
            this.state = RuntimeState.ERROR;
            String name = Names.APPLICATION_DOMAIN_URI.toString();
            throw new Fabric3Exception("Domain not found: " + name);
        }
        eventService.publish((Fabric3Event)new RuntimeRecover());
    }
}

