/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.runtime;

import java.io.File;
import java.net.URI;
import javax.management.MBeanServer;
import org.fabric3.api.annotation.monitor.MonitorLevel;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.host.monitor.DestinationRouter;
import org.fabric3.api.host.monitor.MonitorProxyService;
import org.fabric3.api.host.monitor.Monitorable;
import org.fabric3.api.host.runtime.Fabric3Runtime;
import org.fabric3.api.host.runtime.HostInfo;
import org.fabric3.api.host.runtime.RuntimeConfiguration;
import org.fabric3.contribution.MetaDataStoreImpl;
import org.fabric3.contribution.ProcessorRegistryImpl;
import org.fabric3.fabric.classloader.ClassLoaderRegistryImpl;
import org.fabric3.fabric.container.channel.ChannelManager;
import org.fabric3.fabric.container.channel.ChannelManagerImpl;
import org.fabric3.fabric.container.component.ComponentManagerImpl;
import org.fabric3.fabric.container.component.CompositeScopeContainer;
import org.fabric3.fabric.container.component.ScopeContainerMonitor;
import org.fabric3.fabric.container.component.ScopeRegistryImpl;
import org.fabric3.fabric.domain.LogicalComponentManager;
import org.fabric3.fabric.domain.LogicalComponentManagerImpl;
import org.fabric3.fabric.management.DelegatingManagementService;
import org.fabric3.fabric.runtime.RuntimeServices;
import org.fabric3.monitor.proxy.JDKMonitorProxyService;
import org.fabric3.monitor.proxy.MonitorProxyServiceImpl;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.container.component.ComponentManager;
import org.fabric3.spi.container.component.ScopeContainer;
import org.fabric3.spi.container.component.ScopeRegistry;
import org.fabric3.spi.container.component.ScopedComponent;
import org.fabric3.spi.container.invocation.WorkContextCache;
import org.fabric3.spi.contribution.MetaDataStore;
import org.fabric3.spi.contribution.ProcessorRegistry;
import org.fabric3.spi.management.ManagementService;

public abstract class AbstractRuntime
implements Fabric3Runtime,
RuntimeServices {
    private static final String JAVA_LIBRARY_PATH = "java.library.path";
    private HostInfo hostInfo;
    private MonitorProxyService monitorService;
    private LogicalComponentManager logicalComponentManager;
    private ComponentManager componentManager;
    private ChannelManager channelManager;
    private CompositeScopeContainer scopeContainer;
    private ClassLoaderRegistry classLoaderRegistry;
    private MetaDataStore metaDataStore;
    private ScopeRegistry scopeRegistry;
    private ManagementService managementService;
    private MBeanServer mbServer;
    private DestinationRouter router;
    private MonitorLevel level = MonitorLevel.INFO;

    protected AbstractRuntime(RuntimeConfiguration configuration) {
        this.hostInfo = configuration.getHostInfo();
        this.mbServer = configuration.getMBeanServer();
        this.router = configuration.getDestinationRouter();
        System.setProperty(JAVA_LIBRARY_PATH, new File(this.hostInfo.getTempDir(), "native").getAbsolutePath());
    }

    @Override
    public HostInfo getHostInfo() {
        return this.hostInfo;
    }

    @Override
    public MonitorProxyService getMonitorProxyService() {
        return this.monitorService;
    }

    @Override
    public MBeanServer getMBeanServer() {
        return this.mbServer;
    }

    public String getName() {
        return "fabric3://runtime";
    }

    public MonitorLevel getLevel() {
        return this.level;
    }

    public void setLevel(MonitorLevel level) {
        this.level = level;
    }

    public void boot() throws Fabric3Exception {
        this.logicalComponentManager = new LogicalComponentManagerImpl();
        this.componentManager = new ComponentManagerImpl();
        this.channelManager = new ChannelManagerImpl();
        this.classLoaderRegistry = new ClassLoaderRegistryImpl();
        ProcessorRegistryImpl processorRegistry = new ProcessorRegistryImpl();
        this.metaDataStore = new MetaDataStoreImpl((ProcessorRegistry)processorRegistry);
        this.monitorService = new MonitorProxyServiceImpl(new JDKMonitorProxyService((Monitorable)this, this.router));
        ScopeContainerMonitor monitor = (ScopeContainerMonitor)this.monitorService.createMonitor(ScopeContainerMonitor.class);
        this.scopeContainer = new CompositeScopeContainer(monitor);
        this.scopeContainer.start();
        this.scopeRegistry = new ScopeRegistryImpl();
        this.scopeRegistry.register((ScopeContainer)this.scopeContainer);
        this.managementService = new DelegatingManagementService();
    }

    public void destroy() throws Fabric3Exception {
        WorkContextCache.getAndResetThreadWorkContext();
        this.scopeContainer.stopAllContexts();
        this.classLoaderRegistry.close();
    }

    public <I> I getComponent(Class<I> service, URI uri) {
        if (RuntimeServices.class.equals(service)) {
            return service.cast(this);
        }
        ScopedComponent component = (ScopedComponent)this.componentManager.getComponent(uri);
        if (component == null) {
            return null;
        }
        Object instance = component.getInstance();
        return service.cast(instance);
    }

    public <I> I getComponent(Class<I> service) {
        return this.getComponent(service, URI.create("fabric3://runtime/" + service.getSimpleName()));
    }

    @Override
    public LogicalComponentManager getLogicalComponentManager() {
        return this.logicalComponentManager;
    }

    @Override
    public ComponentManager getComponentManager() {
        return this.componentManager;
    }

    @Override
    public ChannelManager getChannelManager() {
        return this.channelManager;
    }

    @Override
    public ScopeContainer getScopeContainer() {
        return this.scopeContainer;
    }

    @Override
    public ClassLoaderRegistry getClassLoaderRegistry() {
        return this.classLoaderRegistry;
    }

    @Override
    public MetaDataStore getMetaDataStore() {
        return this.metaDataStore;
    }

    @Override
    public ScopeRegistry getScopeRegistry() {
        return this.scopeRegistry;
    }

    @Override
    public ManagementService getManagementService() {
        return this.managementService;
    }

    @Override
    public DestinationRouter getDestinationRouter() {
        return this.router;
    }
}

