/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.node;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import javax.xml.namespace.QName;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.host.contribution.ContributionService;
import org.fabric3.api.host.contribution.ContributionSource;
import org.fabric3.api.host.contribution.UrlContributionSource;
import org.fabric3.api.host.domain.Domain;
import org.fabric3.api.model.type.component.Channel;
import org.fabric3.api.model.type.component.Component;
import org.fabric3.api.model.type.component.Composite;
import org.fabric3.fabric.node.Provisioner;
import org.fabric3.fabric.node.ServiceResolver;
import org.fabric3.spi.container.channel.ChannelResolver;
import org.oasisopen.sca.ServiceRuntimeException;
import org.oasisopen.sca.annotation.Reference;

public class NodeDomain
implements org.fabric3.api.node.Domain {
    private Provisioner provisioner;
    private ServiceResolver serviceResolver;
    private ChannelResolver channelResolver;
    private ContributionService contributionService;
    private Domain domain;

    public NodeDomain(@Reference Provisioner provisioner, @Reference ServiceResolver serviceResolver, @Reference ChannelResolver channelResolver, @Reference ContributionService contributionService, @Reference(name="domain") Domain domain) {
        this.provisioner = provisioner;
        this.serviceResolver = serviceResolver;
        this.channelResolver = channelResolver;
        this.contributionService = contributionService;
        this.domain = domain;
    }

    public <T> T getService(Class<T> interfaze) {
        try {
            return this.serviceResolver.resolve(interfaze);
        }
        catch (Fabric3Exception e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
    }

    public <T> T getChannel(Class<T> interfaze, String name) {
        try {
            return (T)this.channelResolver.getProducer(interfaze, name);
        }
        catch (Fabric3Exception e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
    }

    public org.fabric3.api.node.Domain deploy(Composite composite) {
        try {
            this.provisioner.deploy(composite);
            return this;
        }
        catch (Fabric3Exception e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
    }

    public org.fabric3.api.node.Domain deploy(String name, Object instance, Class<?> ... interfaces) {
        try {
            this.provisioner.deploy(name, instance, interfaces);
            return this;
        }
        catch (Fabric3Exception e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
    }

    public org.fabric3.api.node.Domain deploy(Component<?> component) {
        try {
            this.provisioner.deploy(component);
            return this;
        }
        catch (Fabric3Exception e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
    }

    public org.fabric3.api.node.Domain undeploy(QName name) {
        try {
            this.provisioner.undeploy(name);
            return this;
        }
        catch (Fabric3Exception e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
    }

    public org.fabric3.api.node.Domain undeploy(String name) {
        try {
            this.provisioner.undeploy(name);
            return this;
        }
        catch (Fabric3Exception e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
    }

    public org.fabric3.api.node.Domain deploy(URL url) {
        try {
            URI uri = url.toURI();
            UrlContributionSource source = new UrlContributionSource(uri, url, false);
            this.contributionService.store((ContributionSource)source);
            this.contributionService.install(uri);
            this.domain.include(Collections.singletonList(uri));
            return this;
        }
        catch (URISyntaxException | Fabric3Exception e) {
            throw new ServiceRuntimeException(e);
        }
    }

    public org.fabric3.api.node.Domain undeploy(URL url) {
        try {
            URI uri = url.toURI();
            this.domain.undeploy(uri);
            this.contributionService.uninstall(uri);
            this.contributionService.remove(uri);
            return this;
        }
        catch (URISyntaxException | Fabric3Exception e) {
            throw new ServiceRuntimeException(e);
        }
    }

    public org.fabric3.api.node.Domain deploy(Channel channel) {
        try {
            this.provisioner.deploy(channel);
            return this;
        }
        catch (Fabric3Exception e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
    }
}

