/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.node;

import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.fabric.node.Introspector;
import org.fabric3.spi.introspection.DefaultIntrospectionContext;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.java.contract.JavaContractProcessor;
import org.fabric3.spi.model.type.java.JavaServiceContract;
import org.oasisopen.sca.annotation.Reference;

public class IntrospectorImpl
implements Introspector {
    private JavaContractProcessor contractProcessor;

    public IntrospectorImpl(@Reference JavaContractProcessor contractProcessor) {
        this.contractProcessor = contractProcessor;
    }

    @Override
    public <T> JavaServiceContract introspect(Class<T> interfaze) throws Fabric3Exception {
        DefaultIntrospectionContext context = new DefaultIntrospectionContext();
        JavaServiceContract contract = this.contractProcessor.introspect(interfaze, (IntrospectionContext)context, new ModelObject[0]);
        StringBuilder builder = new StringBuilder();
        if (context.hasErrors()) {
            for (ValidationFailure failure : context.getErrors()) {
                builder.append(failure.getMessage()).append("\n");
            }
            throw new Fabric3Exception(builder.toString());
        }
        return contract;
    }
}

