/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.domain.instantiator.wire;

import java.util.ArrayList;
import java.util.List;
import org.fabric3.api.model.type.component.Multiplicity;
import org.fabric3.api.model.type.contract.ServiceContract;
import org.fabric3.fabric.domain.instantiator.wire.AutowireResolver;
import org.fabric3.spi.contract.ContractMatcher;
import org.fabric3.spi.contract.MatchResult;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalReference;
import org.fabric3.spi.model.instance.LogicalService;
import org.oasisopen.sca.annotation.Reference;

public class TypeAutowireResolver
implements AutowireResolver {
    private ContractMatcher matcher;

    public TypeAutowireResolver(@Reference ContractMatcher matcher) {
        this.matcher = matcher;
    }

    @Override
    public List<LogicalService> resolve(LogicalReference reference, LogicalCompositeComponent composite) {
        ArrayList<LogicalService> candidates = new ArrayList<LogicalService>();
        ServiceContract contract = reference.getServiceContract();
        Multiplicity refMultiplicity = reference.getDefinition().getMultiplicity();
        boolean multiplicity = Multiplicity.ZERO_N.equals((Object)refMultiplicity) || Multiplicity.ONE_N.equals((Object)refMultiplicity);
        for (LogicalComponent child : composite.getComponents()) {
            if (reference.getParent() == child) continue;
            if (this.validKey(reference, child)) {
                for (LogicalService service : child.getServices()) {
                    boolean qualifiersMatch;
                    ServiceContract targetContract = service.getServiceContract();
                    if (targetContract == null) {
                        throw new AssertionError((Object)("No service contract specified on service: " + service.getUri()));
                    }
                    MatchResult result = this.matcher.isAssignableFrom(contract, targetContract, false);
                    if (!result.isAssignable() || !(qualifiersMatch = true)) continue;
                    candidates.add(service);
                    break;
                }
            }
            if (candidates.isEmpty() || multiplicity) continue;
            break;
        }
        return candidates;
    }

    private boolean validKey(LogicalReference logicalReference, LogicalComponent<?> target) {
        return !logicalReference.getDefinition().isKeyed() || target.getDefinition().getKey() != null || target.getDefinition().getComponentType().getKey() != null;
    }
}

