/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.domain.instantiator.component;

import java.net.URI;
import java.util.ArrayList;
import org.fabric3.api.model.type.component.Component;
import org.fabric3.api.model.type.component.Composite;
import org.fabric3.api.model.type.component.Resource;
import org.fabric3.fabric.domain.instantiator.AtomicComponentInstantiator;
import org.fabric3.fabric.domain.instantiator.ChannelInstantiator;
import org.fabric3.fabric.domain.instantiator.CompositeComponentInstantiator;
import org.fabric3.fabric.domain.instantiator.InstantiationContext;
import org.fabric3.fabric.domain.instantiator.WireInstantiator;
import org.fabric3.fabric.domain.instantiator.component.AbstractComponentInstantiator;
import org.fabric3.fabric.domain.instantiator.component.DuplicateComponent;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalResource;
import org.fabric3.spi.model.type.component.CompositeImplementation;
import org.oasisopen.sca.annotation.Constructor;
import org.oasisopen.sca.annotation.Reference;

public class CompositeComponentInstantiatorImpl
extends AbstractComponentInstantiator
implements CompositeComponentInstantiator {
    private AtomicComponentInstantiator atomicInstantiator;
    private WireInstantiator wireInstantiator;
    private ChannelInstantiator channelInstantiator;

    @Constructor
    public CompositeComponentInstantiatorImpl(@Reference AtomicComponentInstantiator atomicInstantiator, @Reference WireInstantiator wireInstantiator, @Reference ChannelInstantiator channelInstantiator) {
        this.atomicInstantiator = atomicInstantiator;
        this.wireInstantiator = wireInstantiator;
        this.channelInstantiator = channelInstantiator;
    }

    public CompositeComponentInstantiatorImpl(AtomicComponentInstantiator atomicInstantiator, WireInstantiator wireInstantiator) {
        this(atomicInstantiator, wireInstantiator, null);
    }

    public LogicalComponent<CompositeImplementation> instantiate(Component<CompositeImplementation> component, LogicalCompositeComponent parent, InstantiationContext context) {
        URI uri = URI.create(parent.getUri() + "/" + component.getName());
        Composite composite = (Composite)Composite.class.cast(component.getComponentType());
        LogicalCompositeComponent logicalComponent = new LogicalCompositeComponent(uri, component, parent);
        this.initializeProperties((LogicalComponent<?>)logicalComponent, component, context);
        this.instantiateChildComponents(logicalComponent, composite, context);
        this.wireInstantiator.instantiateCompositeWires(composite, logicalComponent, context);
        this.instantiateResources(logicalComponent, composite);
        this.wireInstantiator.instantiateCompositeWires(composite, logicalComponent, context);
        if (this.channelInstantiator != null) {
            this.channelInstantiator.instantiateChannels(composite, logicalComponent, context);
        }
        if (parent.getComponent(uri) != null) {
            DuplicateComponent error = new DuplicateComponent(uri, parent);
            context.addError(error);
        }
        parent.addComponent((LogicalComponent)logicalComponent);
        return logicalComponent;
    }

    private void instantiateChildComponents(LogicalCompositeComponent component, Composite composite, InstantiationContext context) {
        ArrayList children = new ArrayList();
        for (Component component2 : composite.getComponents().values()) {
            LogicalComponent<?> childComponent = this.atomicInstantiator.instantiate(component2, component, context);
            component.addComponent(childComponent);
            children.add(childComponent);
        }
        for (LogicalComponent logicalComponent : children) {
            this.wireInstantiator.instantiateReferenceWires(logicalComponent, context);
        }
    }

    private void instantiateResources(LogicalCompositeComponent component, Composite composite) {
        for (Resource definition : composite.getResources()) {
            LogicalResource resource = new LogicalResource(definition, component);
            component.addResource(resource);
        }
    }
}

