/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.domain.instantiator.component;

import java.net.URI;
import org.fabric3.api.model.type.component.Binding;
import org.fabric3.api.model.type.component.Component;
import org.fabric3.api.model.type.component.ComponentType;
import org.fabric3.api.model.type.component.Consumer;
import org.fabric3.api.model.type.component.Producer;
import org.fabric3.api.model.type.component.Reference;
import org.fabric3.api.model.type.component.ResourceReference;
import org.fabric3.api.model.type.component.Service;
import org.fabric3.fabric.domain.instantiator.AtomicComponentInstantiator;
import org.fabric3.fabric.domain.instantiator.InstantiationContext;
import org.fabric3.fabric.domain.instantiator.component.AbstractComponentInstantiator;
import org.fabric3.fabric.domain.instantiator.component.DuplicateComponent;
import org.fabric3.spi.model.instance.LogicalBindable;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalConsumer;
import org.fabric3.spi.model.instance.LogicalProducer;
import org.fabric3.spi.model.instance.LogicalReference;
import org.fabric3.spi.model.instance.LogicalResourceReference;
import org.fabric3.spi.model.instance.LogicalService;

public class AtomicComponentInstantiatorImpl
extends AbstractComponentInstantiator
implements AtomicComponentInstantiator {
    public LogicalComponent instantiate(Component<?> component, LogicalCompositeComponent parent, InstantiationContext context) {
        URI uri = URI.create(parent.getUri() + "/" + component.getName());
        LogicalComponent logicalComponent = new LogicalComponent(uri, component, parent);
        if (parent.getComponent(uri) != null) {
            DuplicateComponent error = new DuplicateComponent(uri, parent);
            context.addError(error);
        }
        parent.addComponent(logicalComponent);
        ComponentType componentType = component.getComponentType();
        if (componentType == null) {
            return logicalComponent;
        }
        this.initializeProperties(logicalComponent, component, context);
        this.createServices(component, logicalComponent, componentType);
        this.createReferences(component, logicalComponent, componentType);
        this.createProducers(component, logicalComponent, componentType);
        this.createConsumers(component, logicalComponent, componentType);
        this.createResourceReferences(logicalComponent, componentType);
        return logicalComponent;
    }

    private void createServices(Component<?> component, LogicalComponent<?> logicalComponent, ComponentType componentType) {
        for (Service service : componentType.getServices().values()) {
            LogicalBinding logicalBinding;
            String name = service.getName();
            URI serviceUri = logicalComponent.getUri().resolve('#' + name);
            LogicalService logicalService = new LogicalService(serviceUri, service, logicalComponent);
            for (Binding binding : service.getBindings()) {
                logicalBinding = new LogicalBinding(binding, (LogicalBindable)logicalService);
                logicalService.addBinding(logicalBinding);
            }
            for (Binding binding : service.getCallbackBindings()) {
                logicalBinding = new LogicalBinding(binding, (LogicalBindable)logicalService);
                logicalService.addCallbackBinding(logicalBinding);
            }
            Service componentService = (Service)component.getServices().get(name);
            if (componentService != null) {
                LogicalBinding logicalBinding2;
                for (Binding binding : componentService.getBindings()) {
                    logicalBinding2 = new LogicalBinding(binding, (LogicalBindable)logicalService);
                    logicalService.addBinding(logicalBinding2);
                }
                for (Binding binding : componentService.getCallbackBindings()) {
                    logicalBinding2 = new LogicalBinding(binding, (LogicalBindable)logicalService);
                    logicalService.addCallbackBinding(logicalBinding2);
                }
            }
            logicalComponent.addService(logicalService);
        }
    }

    private void createReferences(Component<?> component, LogicalComponent<?> logicalComponent, ComponentType componentType) {
        for (Reference reference : componentType.getReferences().values()) {
            LogicalBinding logicalBinding;
            String name = reference.getName();
            URI referenceUri = logicalComponent.getUri().resolve('#' + name);
            LogicalReference logicalReference = new LogicalReference(referenceUri, reference, logicalComponent);
            Reference componentReference = (Reference)component.getReferences().get(name);
            if (componentReference != null) {
                for (Binding binding : componentReference.getBindings()) {
                    logicalBinding = new LogicalBinding(binding, (LogicalBindable)logicalReference);
                    logicalReference.addBinding(logicalBinding);
                }
                for (Binding binding : componentReference.getCallbackBindings()) {
                    logicalBinding = new LogicalBinding(binding, (LogicalBindable)logicalReference);
                    logicalReference.addCallbackBinding(logicalBinding);
                }
            } else {
                for (Binding binding : reference.getBindings()) {
                    logicalBinding = new LogicalBinding(binding, (LogicalBindable)logicalReference);
                    logicalReference.addBinding(logicalBinding);
                }
                for (Binding binding : reference.getCallbackBindings()) {
                    logicalBinding = new LogicalBinding(binding, (LogicalBindable)logicalReference);
                    logicalReference.addCallbackBinding(logicalBinding);
                }
            }
            logicalComponent.addReference(logicalReference);
        }
    }

    private void createConsumers(Component<?> definition, LogicalComponent<?> logicalComponent, ComponentType componentType) {
        for (Consumer consumer : componentType.getConsumers().values()) {
            String name = consumer.getName();
            URI consumerUri = logicalComponent.getUri().resolve('#' + name);
            LogicalConsumer logicalConsumer = new LogicalConsumer(consumerUri, consumer, logicalComponent);
            Consumer componentConsumer = (Consumer)definition.getConsumers().get(name);
            if (componentConsumer != null) {
                for (URI uri : componentConsumer.getSources()) {
                    this.addSource(logicalConsumer, uri, logicalComponent);
                }
            } else {
                for (URI uri : consumer.getSources()) {
                    this.addSource(logicalConsumer, uri, logicalComponent);
                }
            }
            logicalConsumer.setServiceContract(consumer.getServiceContract());
            logicalComponent.addConsumer(logicalConsumer);
        }
    }

    private void createProducers(Component<?> component, LogicalComponent<?> logicalComponent, ComponentType componentType) {
        for (Producer producer : componentType.getProducers().values()) {
            String name = producer.getName();
            URI producerUri = logicalComponent.getUri().resolve('#' + name);
            LogicalProducer logicalProducer = new LogicalProducer(producerUri, producer, logicalComponent);
            Producer componentProducer = (Producer)component.getProducers().get(name);
            if (componentProducer != null) {
                for (URI uri : componentProducer.getTargets()) {
                    this.addTarget(logicalProducer, uri, logicalComponent);
                }
            } else {
                for (URI uri : producer.getTargets()) {
                    this.addTarget(logicalProducer, uri, logicalComponent);
                }
            }
            logicalComponent.addProducer(logicalProducer);
        }
    }

    private void addSource(LogicalConsumer logicalConsumer, URI uri, LogicalComponent<?> logicalComponent) {
        if (uri.isAbsolute()) {
            LogicalComponent domain = (LogicalComponent)logicalComponent.getParent();
            while (domain.getParent() != null) {
                domain = (LogicalComponent)domain.getParent();
            }
            logicalConsumer.addSource(URI.create(domain.getUri().toString() + "/" + uri.getAuthority()));
        } else {
            logicalConsumer.addSource(URI.create(((LogicalCompositeComponent)logicalComponent.getParent()).getUri().toString() + "/" + uri.toString()));
        }
    }

    private void addTarget(LogicalProducer logicalProducer, URI uri, LogicalComponent<?> logicalComponent) {
        if (uri.isAbsolute()) {
            LogicalComponent domain = (LogicalComponent)logicalComponent.getParent();
            while (domain.getParent() != null) {
                domain = (LogicalComponent)domain.getParent();
            }
            logicalProducer.addTarget(URI.create(domain.getUri().toString() + "/" + uri.getAuthority()));
        } else {
            logicalProducer.addTarget(URI.create(((LogicalCompositeComponent)logicalComponent.getParent()).getUri().toString() + "/" + uri.toString()));
        }
    }

    private void createResourceReferences(LogicalComponent<?> logicalComponent, ComponentType componentType) {
        for (ResourceReference reference : componentType.getResourceReferences().values()) {
            URI resourceUri = logicalComponent.getUri().resolve('#' + reference.getName());
            LogicalResourceReference logicalReference = new LogicalResourceReference(resourceUri, reference, logicalComponent);
            logicalComponent.addResource(logicalReference);
        }
    }
}

