/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.domain.generator.wire;

import java.net.URI;
import java.util.List;
import java.util.Set;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.model.type.component.Binding;
import org.fabric3.api.model.type.component.Component;
import org.fabric3.api.model.type.component.Implementation;
import org.fabric3.api.model.type.component.Reference;
import org.fabric3.api.model.type.component.ResourceReference;
import org.fabric3.api.model.type.contract.ServiceContract;
import org.fabric3.fabric.domain.generator.GeneratorRegistry;
import org.fabric3.fabric.domain.generator.wire.PhysicalOperationGenerator;
import org.fabric3.fabric.domain.generator.wire.WireGenerator;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.contract.ContractMatcher;
import org.fabric3.spi.contract.MatchResult;
import org.fabric3.spi.domain.generator.ComponentGenerator;
import org.fabric3.spi.domain.generator.ResourceReferenceGenerator;
import org.fabric3.spi.domain.generator.WireBindingGenerator;
import org.fabric3.spi.model.instance.LogicalBindable;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalReference;
import org.fabric3.spi.model.instance.LogicalResourceReference;
import org.fabric3.spi.model.instance.LogicalService;
import org.fabric3.spi.model.instance.LogicalWire;
import org.fabric3.spi.model.physical.PhysicalOperation;
import org.fabric3.spi.model.physical.PhysicalWire;
import org.fabric3.spi.model.physical.PhysicalWireSource;
import org.fabric3.spi.model.physical.PhysicalWireTarget;
import org.fabric3.spi.util.Cast;

public class WireGeneratorImpl
implements WireGenerator {
    private GeneratorRegistry generatorRegistry;
    private ContractMatcher matcher;
    private PhysicalOperationGenerator operationGenerator;
    private ClassLoaderRegistry classLoaderRegistry;

    public WireGeneratorImpl(@org.oasisopen.sca.annotation.Reference GeneratorRegistry generatorRegistry, @org.oasisopen.sca.annotation.Reference ContractMatcher matcher, @org.oasisopen.sca.annotation.Reference PhysicalOperationGenerator operationGenerator, @org.oasisopen.sca.annotation.Reference ClassLoaderRegistry classLoaderRegistry) {
        this.generatorRegistry = generatorRegistry;
        this.matcher = matcher;
        this.operationGenerator = operationGenerator;
        this.classLoaderRegistry = classLoaderRegistry;
    }

    @Override
    public <T extends Binding> PhysicalWire generateService(LogicalBinding<T> binding, URI callbackUri) {
        this.checkService(binding);
        LogicalService service = (LogicalService)binding.getParent();
        LogicalComponent component = (LogicalComponent)service.getParent();
        ServiceContract contract = service.getServiceContract();
        List operations = service.getOperations();
        ComponentGenerator<LogicalComponent> targetGenerator = this.getGenerator(component);
        PhysicalWireTarget target = targetGenerator.generateTarget(service);
        URI targetUri = ((LogicalComponent)service.getParent()).getDefinition().getContributionUri();
        target.setClassLoader(this.classLoaderRegistry.getClassLoader(targetUri));
        target.setCallbackUri(callbackUri);
        WireBindingGenerator<T> sourceGenerator = this.getGenerator(binding);
        PhysicalWireSource source = sourceGenerator.generateSource(binding, contract, operations);
        URI sourceUri = ((LogicalComponent)service.getParent()).getDefinition().getContributionUri();
        source.setClassLoader(this.classLoaderRegistry.getClassLoader(sourceUri));
        Set<PhysicalOperation> physicalOperations = this.operationGenerator.generateOperations(operations);
        PhysicalWire physicalWire = new PhysicalWire(source, target, physicalOperations);
        boolean optimizable = source.isOptimizable() && target.isOptimizable() && this.checkOptimization(contract, physicalOperations);
        physicalWire.setOptimizable(optimizable);
        return physicalWire;
    }

    @Override
    public <T extends Binding> PhysicalWire generateServiceCallback(LogicalBinding<T> binding) {
        this.checkService(binding);
        LogicalService service = (LogicalService)binding.getParent();
        LogicalComponent component = (LogicalComponent)service.getParent();
        ServiceContract contract = service.getServiceContract();
        ServiceContract callbackContract = contract.getCallbackContract();
        List operations = service.getCallbackOperations();
        ComponentGenerator<LogicalComponent> sourceGenerator = this.getGenerator(component);
        PhysicalWireSource source = sourceGenerator.generateCallbackSource(service);
        URI sourceUri = component.getDefinition().getContributionUri();
        source.setClassLoader(this.classLoaderRegistry.getClassLoader(sourceUri));
        WireBindingGenerator<T> bindingGenerator = this.getGenerator(binding);
        PhysicalWireTarget target = bindingGenerator.generateTarget(binding, callbackContract, operations);
        target.setCallback(true);
        URI targetUri = ((LogicalComponent)((LogicalBindable)binding.getParent()).getParent()).getDefinition().getContributionUri();
        target.setClassLoader(this.classLoaderRegistry.getClassLoader(targetUri));
        Set<PhysicalOperation> physicalOperations = this.operationGenerator.generateOperations(operations);
        return new PhysicalWire(source, target, physicalOperations);
    }

    @Override
    public <T extends Binding> PhysicalWire generateReference(LogicalBinding<T> binding) {
        this.checkReference(binding);
        LogicalReference reference = (LogicalReference)binding.getParent();
        LogicalComponent component = (LogicalComponent)reference.getParent();
        ServiceContract contract = reference.getServiceContract();
        ServiceContract callbackContract = contract.getCallbackContract();
        List operations = reference.getOperations();
        ComponentGenerator<LogicalComponent> sourceGenerator = this.getGenerator(component);
        PhysicalWireSource source = sourceGenerator.generateSource(reference);
        String key = binding.getDefinition().getName();
        source.setKey(key);
        URI sourceUri = component.getDefinition().getContributionUri();
        ClassLoader sourceLoader = this.classLoaderRegistry.getClassLoader(sourceUri);
        source.setClassLoader(sourceLoader);
        WireBindingGenerator<T> targetGenerator = this.getGenerator(binding);
        PhysicalWireTarget target = targetGenerator.generateTarget(binding, contract, operations);
        if (callbackContract != null) {
            Reference referenceDefinition = reference.getDefinition();
            URI callbackUri = this.generateCallbackUri(component, callbackContract, referenceDefinition.getName());
            target.setCallbackUri(callbackUri);
        }
        URI targetUri = ((LogicalComponent)((LogicalBindable)binding.getParent()).getParent()).getDefinition().getContributionUri();
        ClassLoader targetLoader = this.classLoaderRegistry.getClassLoader(targetUri);
        target.setClassLoader(targetLoader);
        Set<PhysicalOperation> physicalOperations = this.operationGenerator.generateOperations(operations);
        return new PhysicalWire(source, target, physicalOperations);
    }

    @Override
    public <T extends Binding> PhysicalWire generateReferenceCallback(LogicalBinding<T> binding) {
        this.checkReference(binding);
        LogicalReference reference = (LogicalReference)binding.getParent();
        LogicalComponent component = (LogicalComponent)reference.getParent();
        ServiceContract contract = reference.getServiceContract();
        ServiceContract callbackContract = contract.getCallbackContract();
        LogicalService callbackService = component.getService(callbackContract.getInterfaceName());
        List operations = reference.getCallbackOperations();
        WireBindingGenerator<T> sourceGenerator = this.getGenerator(binding);
        PhysicalWireSource source = sourceGenerator.generateSource(binding, callbackContract, operations);
        URI sourceUri = ((LogicalComponent)((LogicalBindable)binding.getParent()).getParent()).getDefinition().getContributionUri();
        source.setClassLoader(this.classLoaderRegistry.getClassLoader(sourceUri));
        ComponentGenerator<LogicalComponent> targetGenerator = this.getGenerator(component);
        PhysicalWireTarget target = targetGenerator.generateTarget(callbackService);
        URI targetUri = ((LogicalComponent)callbackService.getParent()).getDefinition().getContributionUri();
        target.setClassLoader(this.classLoaderRegistry.getClassLoader(targetUri));
        target.setCallback(true);
        Set<PhysicalOperation> operation = this.operationGenerator.generateOperations(operations);
        return new PhysicalWire(source, target, operation);
    }

    @Override
    public PhysicalWire generateWire(LogicalWire wire) {
        return this.generateLocalWire(wire);
    }

    @Override
    public PhysicalWire generateWireCallback(LogicalWire wire) {
        return this.generateLocalWireCallback(wire);
    }

    @Override
    public <T extends ResourceReference> PhysicalWire generateResource(LogicalResourceReference<T> logicalReference) {
        ResourceReference reference = logicalReference.getDefinition();
        LogicalComponent component = (LogicalComponent)logicalReference.getParent();
        ComponentGenerator<LogicalComponent> sourceGenerator = this.getGenerator(component);
        PhysicalWireSource source = sourceGenerator.generateResourceSource(logicalReference);
        URI sourceUri = component.getDefinition().getContributionUri();
        source.setClassLoader(this.classLoaderRegistry.getClassLoader(sourceUri));
        ResourceReferenceGenerator<ResourceReference> targetGenerator = this.getGenerator(reference);
        PhysicalWireTarget target = targetGenerator.generateWireTarget(logicalReference);
        URI targetUri = ((LogicalComponent)logicalReference.getParent()).getDefinition().getContributionUri();
        target.setClassLoader(this.classLoaderRegistry.getClassLoader(targetUri));
        boolean optimizable = target.isOptimizable();
        List sourceOperations = logicalReference.getOperations();
        Set<PhysicalOperation> operations = this.operationGenerator.generateOperations(sourceOperations);
        PhysicalWire physicalWire = new PhysicalWire(source, target, operations);
        physicalWire.setOptimizable(optimizable);
        return physicalWire;
    }

    private PhysicalWire generateLocalWire(LogicalWire wire) {
        LogicalReference reference = wire.getSource();
        LogicalService service = wire.getTarget();
        LogicalComponent sourceComponent = (LogicalComponent)reference.getParent();
        LogicalComponent targetComponent = (LogicalComponent)service.getParent();
        Reference referenceDefinition = reference.getDefinition();
        ServiceContract referenceContract = reference.getServiceContract();
        ComponentGenerator<LogicalComponent> sourceGenerator = this.getGenerator(sourceComponent);
        PhysicalWireSource source = sourceGenerator.generateSource(reference);
        URI sourceUri = sourceComponent.getDefinition().getContributionUri();
        source.setClassLoader(this.classLoaderRegistry.getClassLoader(sourceUri));
        String key = this.getKey(targetComponent);
        source.setKey(key);
        int order = this.getOrder(targetComponent);
        source.setOrder(order);
        ComponentGenerator<LogicalComponent> targetGenerator = this.getGenerator(targetComponent);
        PhysicalWireTarget target = targetGenerator.generateTarget(service);
        URI targetUri = targetComponent.getDefinition().getContributionUri();
        target.setClassLoader(this.classLoaderRegistry.getClassLoader(targetUri));
        ServiceContract serviceContract = service.getServiceContract();
        ServiceContract callbackContract = serviceContract.getCallbackContract();
        if (callbackContract != null) {
            URI callbackUri = this.generateCallbackUri(sourceComponent, callbackContract, referenceDefinition.getName());
            target.setCallbackUri(callbackUri);
        }
        List sourceOperations = reference.getOperations();
        List targetOperations = service.getOperations();
        Set<PhysicalOperation> operations = this.operationGenerator.generateOperations(sourceOperations, targetOperations, false);
        PhysicalWire physicalWire = new PhysicalWire(source, target, operations);
        boolean optimizable = source.isOptimizable() && target.isOptimizable() && this.checkOptimization(referenceContract, operations);
        physicalWire.setOptimizable(optimizable);
        return physicalWire;
    }

    private PhysicalWire generateLocalWireCallback(LogicalWire wire) {
        LogicalReference reference = wire.getSource();
        LogicalService service = wire.getTarget();
        LogicalComponent targetComponent = (LogicalComponent)reference.getParent();
        ServiceContract referenceCallbackContract = reference.getServiceContract().getCallbackContract();
        LogicalService callbackService = targetComponent.getService(referenceCallbackContract.getInterfaceName());
        LogicalComponent sourceComponent = (LogicalComponent)service.getParent();
        List targetOperations = callbackService.getOperations();
        List sourceOperations = service.getCallbackOperations();
        Set<PhysicalOperation> callbackOperations = this.operationGenerator.generateOperations(targetOperations, sourceOperations, false);
        ComponentGenerator<LogicalComponent> sourceGenerator = this.getGenerator(sourceComponent);
        PhysicalWireSource source = sourceGenerator.generateCallbackSource(service);
        URI sourceUri = sourceComponent.getDefinition().getContributionUri();
        source.setClassLoader(this.classLoaderRegistry.getClassLoader(sourceUri));
        ComponentGenerator<LogicalComponent> targetGenerator = this.getGenerator(targetComponent);
        PhysicalWireTarget target = targetGenerator.generateTarget(callbackService);
        URI targetUri = targetComponent.getDefinition().getContributionUri();
        target.setClassLoader(this.classLoaderRegistry.getClassLoader(targetUri));
        target.setCallback(true);
        PhysicalWire physicalWire = new PhysicalWire(source, target, callbackOperations);
        physicalWire.setOptimizable(false);
        return physicalWire;
    }

    private <S extends LogicalComponent<?>> URI generateCallbackUri(S source, ServiceContract contract, String referenceName) {
        LogicalService candidate = null;
        for (LogicalService entry : source.getServices()) {
            MatchResult result = this.matcher.isAssignableFrom(contract, entry.getServiceContract(), false);
            if (!result.isAssignable()) continue;
            candidate = entry;
            break;
        }
        if (candidate == null) {
            String name = contract.getInterfaceName();
            URI uri = source.getUri();
            throw new Fabric3Exception("Callback service not found: " + name + " on component: " + uri + " originating from reference :" + referenceName);
        }
        return URI.create(source.getUri().toString() + "#" + candidate.getDefinition().getName());
    }

    private boolean checkOptimization(ServiceContract serviceContract, Set<PhysicalOperation> operationDefinitions) {
        if (serviceContract.isRemotable()) {
            return false;
        }
        for (PhysicalOperation operation : operationDefinitions) {
            if (operation.getInterceptors().isEmpty()) continue;
            return false;
        }
        return true;
    }

    private String getKey(LogicalComponent component) {
        String key = component.getDefinition().getKey();
        if (key == null && component.getDefinition().getComponentType() != null) {
            key = component.getDefinition().getComponentType().getKey();
        }
        return key;
    }

    private int getOrder(LogicalComponent logicalComponent) {
        Component component;
        int order = logicalComponent.getDefinition().getOrder();
        if (order == Integer.MIN_VALUE && (component = logicalComponent.getDefinition()).getComponentType() != null) {
            order = component.getComponentType().getOrder();
        }
        return order;
    }

    private <C extends LogicalComponent<?>> ComponentGenerator<C> getGenerator(C component) {
        Implementation implementation = component.getDefinition().getImplementation();
        return (ComponentGenerator)Cast.cast(this.generatorRegistry.getComponentGenerator(implementation.getClass()));
    }

    private <T extends ResourceReference> ResourceReferenceGenerator<T> getGenerator(T reference) {
        return (ResourceReferenceGenerator)Cast.cast(this.generatorRegistry.getResourceReferenceGenerator(reference.getClass()));
    }

    private <T extends Binding> WireBindingGenerator<T> getGenerator(LogicalBinding<T> binding) {
        return (WireBindingGenerator)Cast.cast(this.generatorRegistry.getBindingGenerator(binding.getDefinition().getClass()));
    }

    private void checkService(LogicalBinding<?> binding) {
        if (!(binding.getParent() instanceof LogicalService)) {
            throw new AssertionError((Object)("Expected " + LogicalService.class.getName() + " as parent to binding"));
        }
    }

    private void checkReference(LogicalBinding binding) {
        if (!(binding.getParent() instanceof LogicalReference)) {
            throw new AssertionError((Object)("Expected " + LogicalReference.class.getName() + " as parent to binding"));
        }
    }
}

