/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.domain.generator.wire;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.api.model.type.component.Binding;
import org.fabric3.api.model.type.component.Multiplicity;
import org.fabric3.fabric.container.command.AttachWireCommand;
import org.fabric3.fabric.container.command.ConnectionCommand;
import org.fabric3.fabric.container.command.DetachWireCommand;
import org.fabric3.fabric.domain.generator.CommandGenerator;
import org.fabric3.fabric.domain.generator.wire.WireGenerator;
import org.fabric3.spi.domain.generator.CallbackBindingGenerator;
import org.fabric3.spi.model.instance.LogicalBindable;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalReference;
import org.fabric3.spi.model.instance.LogicalService;
import org.fabric3.spi.model.instance.LogicalState;
import org.fabric3.spi.model.instance.LogicalWire;
import org.fabric3.spi.model.physical.PhysicalWire;
import org.oasisopen.sca.annotation.Reference;

public class ReferenceCommandGenerator
implements CommandGenerator<ConnectionCommand> {
    private WireGenerator wireGenerator;
    private Map<Class<?>, CallbackBindingGenerator> generators = Collections.emptyMap();

    public ReferenceCommandGenerator(@Reference WireGenerator wireGenerator) {
        this.wireGenerator = wireGenerator;
    }

    @Reference(required=false)
    public void setCallbackBindingGenerators(Map<Class<?>, CallbackBindingGenerator> generators) {
        this.generators = generators;
    }

    @Override
    public int getOrder() {
        return 3;
    }

    @Override
    public Optional<ConnectionCommand> generate(LogicalComponent<?> component) {
        if (component instanceof LogicalCompositeComponent) {
            return Optional.empty();
        }
        ConnectionCommand command = new ConnectionCommand(component.getUri());
        for (LogicalReference reference : component.getReferences()) {
            if (!reference.getWires().isEmpty()) {
                this.generateWires(reference, command);
                continue;
            }
            this.generateBindings(reference, component, command);
        }
        if (command.getAttachCommands().isEmpty() && command.getDetachCommands().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(command);
    }

    private void generateBindings(LogicalReference reference, LogicalComponent<?> component, ConnectionCommand command) {
        boolean bindings;
        boolean reinjection = this.isBoundReinjection(reference);
        for (LogicalBinding logicalBinding : reference.getBindings()) {
            this.generateBinding(component, logicalBinding, command, reinjection, false);
        }
        if (reference.getServiceContract().getCallbackContract() != null && (bindings = reference.isBound())) {
            List callbackBindings = reference.getCallbackBindings();
            if (callbackBindings.isEmpty()) {
                this.generateCallbackBindings(reference);
            }
            if (callbackBindings.size() != 1) {
                String uri = reference.getUri().toString();
                throw new UnsupportedOperationException("The runtime requires exactly one callback binding to be specified on reference: " + uri);
            }
            LogicalBinding callbackBinding = (LogicalBinding)callbackBindings.get(0);
            this.generateBinding(component, callbackBinding, command, reinjection, true);
        }
    }

    private void generateBinding(LogicalComponent<?> component, LogicalBinding<?> logicalBinding, ConnectionCommand command, boolean reinjection, boolean callback) {
        if (LogicalState.MARKED == component.getState() || LogicalState.MARKED == logicalBinding.getState()) {
            PhysicalWire physicalWire = callback ? this.wireGenerator.generateReferenceCallback(logicalBinding) : this.wireGenerator.generateReference(logicalBinding);
            DetachWireCommand wireCommand = new DetachWireCommand();
            wireCommand.setPhysicalWireDefinition(physicalWire);
            command.add(wireCommand);
        } else if (LogicalState.NEW == logicalBinding.getState() || reinjection) {
            PhysicalWire physicalWire = callback ? this.wireGenerator.generateReferenceCallback(logicalBinding) : this.wireGenerator.generateReference(logicalBinding);
            AttachWireCommand wireCommand = new AttachWireCommand();
            wireCommand.setPhysicalWireDefinition(physicalWire);
            command.add(wireCommand);
        }
    }

    private void generateWires(LogicalReference reference, ConnectionCommand command) {
        boolean reinjection = this.isWireReinjection(reference);
        for (LogicalWire wire : reference.getWires()) {
            AttachWireCommand attachCommand;
            DetachWireCommand detachCommand;
            PhysicalWire physicalWire;
            LogicalService service = wire.getTarget();
            LogicalComponent targetComponent = (LogicalComponent)service.getParent();
            if (!reinjection && wire.getState() == LogicalState.PROVISIONED && targetComponent.getState() != LogicalState.MARKED) continue;
            boolean attach = true;
            if (targetComponent.getState() == LogicalState.MARKED || wire.getState() == LogicalState.MARKED) {
                attach = false;
                physicalWire = wire.getSourceBinding() != null && wire.getTargetBinding() == null ? this.wireGenerator.generateReference(wire.getSourceBinding()) : this.wireGenerator.generateWire(wire);
                detachCommand = new DetachWireCommand();
                detachCommand.setPhysicalWireDefinition(physicalWire);
                command.add(detachCommand);
            } else if (reinjection && targetComponent.getState() == LogicalState.NEW || wire.getState() == LogicalState.NEW || targetComponent.getState() == LogicalState.NEW) {
                physicalWire = wire.getSourceBinding() != null && wire.getTargetBinding() == null ? this.wireGenerator.generateReference(wire.getSourceBinding()) : this.wireGenerator.generateWire(wire);
                attachCommand = new AttachWireCommand();
                attachCommand.setPhysicalWireDefinition(physicalWire);
                command.add(attachCommand);
            }
            if (reference.getServiceContract().getCallbackContract() == null) continue;
            physicalWire = wire.getSourceBinding() != null && wire.getTargetBinding() == null ? this.wireGenerator.generateReferenceCallback((LogicalBinding)reference.getCallbackBindings().get(0)) : this.wireGenerator.generateWireCallback(wire);
            if (attach) {
                attachCommand = new AttachWireCommand();
                attachCommand.setPhysicalWireDefinition(physicalWire);
                command.add(attachCommand);
                continue;
            }
            detachCommand = new DetachWireCommand();
            detachCommand.setPhysicalWireDefinition(physicalWire);
            command.add(detachCommand);
        }
    }

    private void generateCallbackBindings(LogicalReference reference) {
        for (LogicalBinding logicalBinding : reference.getBindings()) {
            CallbackBindingGenerator generator = this.generators.get(logicalBinding.getDefinition().getClass());
            if (generator == null) {
                throw new Fabric3Exception("Callback generator not found for:" + logicalBinding.getDefinition().getType());
            }
            Binding definition = generator.generateReferenceCallback(logicalBinding);
            definition.setParent((ModelObject)reference.getDefinition());
            LogicalBinding logicalCallback = new LogicalBinding(definition, (LogicalBindable)reference);
            reference.addCallbackBinding(logicalCallback);
        }
    }

    private boolean isWireReinjection(LogicalReference logicalReference) {
        Multiplicity multiplicity = logicalReference.getDefinition().getMultiplicity();
        if (multiplicity == Multiplicity.ZERO_N || multiplicity == Multiplicity.ONE_N) {
            for (LogicalWire wire : logicalReference.getWires()) {
                LogicalComponent targetComponent = (LogicalComponent)wire.getTarget().getParent();
                if (wire.getState() != LogicalState.NEW && wire.getState() != LogicalState.MARKED && targetComponent.getState() != LogicalState.NEW && targetComponent.getState() != LogicalState.MARKED) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isBoundReinjection(LogicalReference logicalReference) {
        Multiplicity multiplicity = logicalReference.getDefinition().getMultiplicity();
        if (multiplicity == Multiplicity.ZERO_N || multiplicity == Multiplicity.ONE_N) {
            for (LogicalBinding binding : logicalReference.getBindings()) {
                if (binding.getState() != LogicalState.NEW && binding.getState() != LogicalState.MARKED) continue;
                return true;
            }
        }
        return false;
    }
}

