/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.domain.generator.resource;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.model.type.component.Resource;
import org.fabric3.fabric.container.command.BuildResourcesCommand;
import org.fabric3.fabric.container.command.Command;
import org.fabric3.fabric.container.command.DisposeResourcesCommand;
import org.fabric3.fabric.domain.generator.GeneratorRegistry;
import org.fabric3.fabric.domain.generator.resource.DomainResourceCommandGenerator;
import org.fabric3.spi.domain.generator.ResourceGenerator;
import org.fabric3.spi.model.instance.LogicalResource;
import org.fabric3.spi.model.instance.LogicalState;
import org.fabric3.spi.model.physical.PhysicalResource;
import org.oasisopen.sca.annotation.Reference;

public class DomainResourceCommandGeneratorImpl
implements DomainResourceCommandGenerator {
    private GeneratorRegistry generatorRegistry;

    public DomainResourceCommandGeneratorImpl(@Reference GeneratorRegistry generatorRegistry) {
        this.generatorRegistry = generatorRegistry;
    }

    @Override
    public Optional<Command> generateBuild(LogicalResource resource) throws Fabric3Exception {
        if (resource.getState() != LogicalState.NEW) {
            return Optional.empty();
        }
        List<PhysicalResource> physicalResources = this.createPhysicalResources(resource);
        if (physicalResources.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new BuildResourcesCommand(physicalResources));
    }

    @Override
    public Optional<Command> generateDispose(LogicalResource resource) throws Fabric3Exception {
        if (resource.getState() != LogicalState.MARKED) {
            return Optional.empty();
        }
        List<PhysicalResource> physicalResources = this.createPhysicalResources(resource);
        if (physicalResources.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new DisposeResourcesCommand(physicalResources));
    }

    private List<PhysicalResource> createPhysicalResources(LogicalResource logicalResource) throws Fabric3Exception {
        ArrayList<PhysicalResource> physicalResources = new ArrayList<PhysicalResource>();
        Resource resource = logicalResource.getDefinition();
        ResourceGenerator<?> generator = this.generatorRegistry.getResourceGenerator(resource.getClass());
        PhysicalResource physicalResource = generator.generateResource(logicalResource);
        physicalResources.add(physicalResource);
        return physicalResources;
    }
}

