/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.domain.generator.resource;

import java.util.ArrayList;
import java.util.Optional;
import org.fabric3.api.model.type.component.Resource;
import org.fabric3.fabric.container.command.DisposeResourcesCommand;
import org.fabric3.fabric.domain.generator.CommandGenerator;
import org.fabric3.fabric.domain.generator.GeneratorRegistry;
import org.fabric3.spi.domain.generator.ResourceGenerator;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalResource;
import org.fabric3.spi.model.instance.LogicalState;
import org.fabric3.spi.model.physical.PhysicalResource;
import org.oasisopen.sca.annotation.Reference;

public class DisposeResourceCommandGenerator
implements CommandGenerator<DisposeResourcesCommand> {
    private GeneratorRegistry generatorRegistry;

    public DisposeResourceCommandGenerator(@Reference GeneratorRegistry generatorRegistry) {
        this.generatorRegistry = generatorRegistry;
    }

    @Override
    public int getOrder() {
        return 6;
    }

    @Override
    public Optional<DisposeResourcesCommand> generate(LogicalComponent<?> component) {
        if (!(component instanceof LogicalCompositeComponent) || component.getState() != LogicalState.MARKED) {
            return Optional.empty();
        }
        LogicalCompositeComponent composite = (LogicalCompositeComponent)component;
        if (composite.getResources().isEmpty()) {
            return Optional.empty();
        }
        ArrayList<PhysicalResource> physicalResources = new ArrayList<PhysicalResource>();
        for (LogicalResource logicalResource : composite.getResources()) {
            Resource resource = logicalResource.getDefinition();
            ResourceGenerator<?> generator = this.generatorRegistry.getResourceGenerator(resource.getClass());
            PhysicalResource physicalResource = generator.generateResource(logicalResource);
            physicalResources.add(physicalResource);
        }
        if (physicalResources.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new DisposeResourcesCommand(physicalResources));
    }
}

