/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.domain.generator.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.model.type.component.Binding;
import org.fabric3.api.model.type.component.Implementation;
import org.fabric3.api.model.type.component.Resource;
import org.fabric3.api.model.type.component.ResourceReference;
import org.fabric3.fabric.domain.generator.GeneratorRegistry;
import org.fabric3.spi.domain.generator.ComponentGenerator;
import org.fabric3.spi.domain.generator.ConnectionBindingGenerator;
import org.fabric3.spi.domain.generator.InterceptorGenerator;
import org.fabric3.spi.domain.generator.ResourceGenerator;
import org.fabric3.spi.domain.generator.ResourceReferenceGenerator;
import org.fabric3.spi.domain.generator.WireBindingGenerator;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.oasisopen.sca.annotation.Reference;

public class GeneratorRegistryImpl
implements GeneratorRegistry {
    @Reference(required=false)
    protected Map<Class<?>, ComponentGenerator<?>> componentGenerators = new HashMap();
    @Reference(required=false)
    protected Map<Class<?>, WireBindingGenerator<?>> bindingGenerators = new HashMap();
    @Reference(required=false)
    protected Map<Class<?>, ConnectionBindingGenerator<?>> connectionBindingGenerators = new HashMap();
    @Reference(required=false)
    protected List<InterceptorGenerator> interceptorGenerators = new ArrayList<InterceptorGenerator>();
    @Reference(required=false)
    protected Map<Class<?>, ResourceReferenceGenerator<?>> resourceReferenceGenerators = new HashMap();
    @Reference(required=false)
    protected Map<Class<?>, ResourceGenerator<?>> resourceGenerators = new HashMap();

    public <T extends Implementation<?>> void register(Class<T> clazz, ComponentGenerator<LogicalComponent<T>> generator) {
        this.componentGenerators.put(clazz, generator);
    }

    public <T extends ResourceReference> void register(Class<T> clazz, ResourceReferenceGenerator<T> generator) {
        this.resourceReferenceGenerators.put(clazz, generator);
    }

    public <T extends Binding> void register(Class<T> clazz, WireBindingGenerator<T> generator) {
        this.bindingGenerators.put(clazz, generator);
    }

    @Override
    public <T extends Implementation<?>> ComponentGenerator<LogicalComponent<T>> getComponentGenerator(Class<T> clazz) {
        ComponentGenerator<?> generator = this.componentGenerators.get(clazz);
        if (generator == null) {
            throw new Fabric3Exception("Component generator not found for " + clazz.getName());
        }
        return generator;
    }

    @Override
    public <T extends Binding> WireBindingGenerator<T> getBindingGenerator(Class<T> clazz) {
        WireBindingGenerator<?> generator = this.bindingGenerators.get(clazz);
        if (generator == null) {
            throw new Fabric3Exception("Wire binding generator not found for " + clazz.getName());
        }
        return generator;
    }

    public <T extends Binding> ConnectionBindingGenerator<T> getConnectionBindingGenerator(Class<T> clazz) {
        ConnectionBindingGenerator<?> generator = this.connectionBindingGenerators.get(clazz);
        if (generator == null) {
            throw new Fabric3Exception("Connection binding generator not found for " + clazz.getName());
        }
        return generator;
    }

    @Override
    public <T extends ResourceReference> ResourceReferenceGenerator<T> getResourceReferenceGenerator(Class<T> clazz) {
        ResourceReferenceGenerator<?> generator = this.resourceReferenceGenerators.get(clazz);
        if (generator == null) {
            throw new Fabric3Exception("Resource reference generator not found for " + clazz.getName());
        }
        return generator;
    }

    @Override
    public List<InterceptorGenerator> getInterceptorGenerators() {
        return this.interceptorGenerators;
    }

    @Override
    public <T extends Resource> ResourceGenerator<T> getResourceGenerator(Class<T> clazz) {
        ResourceGenerator<?> generator = this.resourceGenerators.get(clazz);
        if (generator == null) {
            throw new Fabric3Exception("Resource generator not found for " + clazz.getName());
        }
        return generator;
    }
}

