/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.domain.generator.context;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.fabric.container.command.Command;
import org.fabric3.fabric.container.command.StartContextCommand;
import org.fabric3.fabric.domain.generator.context.StartContextCommandGenerator;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalState;
import org.oasisopen.sca.annotation.EagerInit;

@EagerInit
public class StartContextCommandGeneratorImpl
implements StartContextCommandGenerator {
    @Override
    public List<Command> generate(List<LogicalComponent<?>> components) throws Fabric3Exception {
        ArrayList<Command> commands = new ArrayList<Command>();
        components.stream().filter(component -> component.getState() == LogicalState.NEW).forEach(component -> {
            boolean log;
            URI uri = component.getDefinition().getContributionUri();
            StartContextCommand command = new StartContextCommand(uri, log = !component.getUri().toString().startsWith("fabric3://runtime"));
            if (!commands.contains(command)) {
                commands.add(command);
            }
        });
        return commands;
    }
}

