/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.domain.generator.channel;

import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.fabric3.fabric.container.command.AttachChannelConnectionCommand;
import org.fabric3.fabric.container.command.BuildChannelCommand;
import org.fabric3.fabric.container.command.ChannelConnectionCommand;
import org.fabric3.fabric.container.command.DetachChannelConnectionCommand;
import org.fabric3.fabric.container.command.DisposeChannelCommand;
import org.fabric3.fabric.domain.generator.CommandGenerator;
import org.fabric3.fabric.domain.generator.channel.ChannelCommandGenerator;
import org.fabric3.fabric.domain.generator.channel.ChannelDirection;
import org.fabric3.fabric.domain.generator.channel.ConnectionGenerator;
import org.fabric3.fabric.domain.generator.channel.InvocableGeneratorHelper;
import org.fabric3.spi.model.instance.LogicalChannel;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalConsumer;
import org.fabric3.spi.model.instance.LogicalInvocable;
import org.fabric3.spi.model.instance.LogicalState;
import org.fabric3.spi.model.physical.DeliveryType;
import org.fabric3.spi.model.physical.PhysicalChannelConnection;
import org.oasisopen.sca.annotation.Reference;

public class ConsumerCommandGenerator
implements CommandGenerator<ChannelConnectionCommand> {
    private ConnectionGenerator connectionGenerator;
    private ChannelCommandGenerator channelGenerator;

    public ConsumerCommandGenerator(@Reference ConnectionGenerator connectionGenerator, @Reference ChannelCommandGenerator channelGenerator) {
        this.connectionGenerator = connectionGenerator;
        this.channelGenerator = channelGenerator;
    }

    @Override
    public int getOrder() {
        return 3;
    }

    @Override
    public Optional<ChannelConnectionCommand> generate(LogicalComponent<?> component) {
        if (component instanceof LogicalCompositeComponent) {
            return Optional.empty();
        }
        ChannelConnectionCommand command = new ChannelConnectionCommand();
        for (LogicalConsumer consumer : component.getConsumers()) {
            this.generateCommand(consumer, command);
        }
        if (command.getAttachCommands().isEmpty() && command.getDetachCommands().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(command);
    }

    private void generateCommand(LogicalConsumer consumer, ChannelConnectionCommand command) {
        block5: {
            URI contributionUri;
            LogicalComponent component;
            block4: {
                component = (LogicalComponent)consumer.getParent();
                contributionUri = ((LogicalComponent)consumer.getParent()).getDefinition().getContributionUri();
                if (LogicalState.MARKED != component.getState()) break block4;
                HashMap<LogicalChannel, DeliveryType> channels = new HashMap<LogicalChannel, DeliveryType>();
                for (Object uri : consumer.getSources()) {
                    LogicalChannel channel = InvocableGeneratorHelper.getChannelInHierarchy((URI)uri, (LogicalInvocable)consumer);
                    DisposeChannelCommand disposeCommand = this.channelGenerator.generateDispose(channel, contributionUri, ChannelDirection.CONSUMER);
                    command.addDisposeChannelCommand(disposeCommand);
                    channels.put(channel, disposeCommand.getChannel().getDeliveryType());
                }
                List<PhysicalChannelConnection> connections = this.connectionGenerator.generateConsumer(consumer, channels);
                for (PhysicalChannelConnection connection : connections) {
                    DetachChannelConnectionCommand connectionCommand = new DetachChannelConnectionCommand(connection);
                    command.add(connectionCommand);
                }
                break block5;
            }
            if (LogicalState.NEW != component.getState()) break block5;
            HashMap<LogicalChannel, DeliveryType> channels = new HashMap<LogicalChannel, DeliveryType>();
            for (URI uri : consumer.getSources()) {
                LogicalChannel channel = InvocableGeneratorHelper.getChannelInHierarchy(uri, (LogicalInvocable)consumer);
                BuildChannelCommand buildCommand = this.channelGenerator.generateBuild(channel, contributionUri, ChannelDirection.CONSUMER);
                command.addBuildChannelCommand(buildCommand);
                channels.put(channel, buildCommand.getChannel().getDeliveryType());
            }
            List<PhysicalChannelConnection> connections = this.connectionGenerator.generateConsumer(consumer, channels);
            Iterator iterator = connections.iterator();
            while (iterator.hasNext()) {
                PhysicalChannelConnection connection = (PhysicalChannelConnection)iterator.next();
                AttachChannelConnectionCommand connectionCommand = new AttachChannelConnectionCommand(connection);
                command.add(connectionCommand);
            }
        }
    }
}

