/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.domain.generator.channel;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.model.type.component.Binding;
import org.fabric3.api.model.type.component.Channel;
import org.fabric3.api.model.type.component.Consumer;
import org.fabric3.api.model.type.component.Implementation;
import org.fabric3.api.model.type.contract.DataType;
import org.fabric3.api.model.type.contract.Operation;
import org.fabric3.api.model.type.contract.ServiceContract;
import org.fabric3.fabric.domain.generator.GeneratorRegistry;
import org.fabric3.fabric.domain.generator.channel.ConnectionGenerator;
import org.fabric3.fabric.model.physical.ChannelSource;
import org.fabric3.fabric.model.physical.ChannelTarget;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.domain.generator.ComponentGenerator;
import org.fabric3.spi.domain.generator.ConnectionBindingGenerator;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.spi.model.instance.LogicalChannel;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalConsumer;
import org.fabric3.spi.model.instance.LogicalInvocable;
import org.fabric3.spi.model.instance.LogicalProducer;
import org.fabric3.spi.model.physical.ChannelSide;
import org.fabric3.spi.model.physical.DeliveryType;
import org.fabric3.spi.model.physical.PhysicalChannelConnection;
import org.fabric3.spi.model.physical.PhysicalConnectionSource;
import org.fabric3.spi.model.physical.PhysicalConnectionTarget;
import org.oasisopen.sca.annotation.Reference;

public class ConnectionGeneratorImpl
implements ConnectionGenerator {
    private GeneratorRegistry generatorRegistry;
    private ClassLoaderRegistry classLoaderRegistry;

    public ConnectionGeneratorImpl(@Reference GeneratorRegistry generatorRegistry, @Reference ClassLoaderRegistry classLoaderRegistry) {
        this.generatorRegistry = generatorRegistry;
        this.classLoaderRegistry = classLoaderRegistry;
    }

    @Override
    public List<PhysicalChannelConnection> generateProducer(LogicalProducer producer, Map<LogicalChannel, DeliveryType> channels) {
        LogicalComponent component = (LogicalComponent)producer.getParent();
        ComponentGenerator<LogicalComponent> componentGenerator = this.getGenerator(component);
        PhysicalConnectionSource source = componentGenerator.generateConnectionSource(producer);
        URI classLoaderId = component.getDefinition().getContributionUri();
        ClassLoader classLoader = this.classLoaderRegistry.getClassLoader(classLoaderId);
        source.setClassLoader(classLoader);
        if (this.isDirect((LogicalInvocable)producer, channels)) {
            source.setDirectConnection(true);
            return this.generateDirectConnections(producer, channels, source, classLoader);
        }
        return this.generateConnections(producer, channels, source, classLoader);
    }

    @Override
    public List<PhysicalChannelConnection> generateConsumer(LogicalConsumer consumer, Map<LogicalChannel, DeliveryType> channels) {
        LogicalComponent component = (LogicalComponent)consumer.getParent();
        ComponentGenerator<LogicalComponent> generator = this.getGenerator(component);
        PhysicalConnectionTarget target = generator.generateConnectionTarget(consumer);
        URI classLoaderId = component.getDefinition().getContributionUri();
        ClassLoader classLoader = this.classLoaderRegistry.getClassLoader(classLoaderId);
        target.setClassLoader(classLoader);
        if (this.isDirect((LogicalInvocable)consumer, channels)) {
            target.setDirectConnection(true);
            return this.generateDirectConnections(consumer, channels, target, classLoader);
        }
        return this.generateConnections(consumer, channels, target, classLoader);
    }

    private List<PhysicalChannelConnection> generateDirectConnections(LogicalConsumer consumer, Map<LogicalChannel, DeliveryType> channels, PhysicalConnectionTarget target, ClassLoader classLoader) {
        ArrayList<PhysicalChannelConnection> connections = new ArrayList<PhysicalChannelConnection>();
        for (Map.Entry<LogicalChannel, DeliveryType> entry : channels.entrySet()) {
            LogicalChannel channel = entry.getKey();
            if (!channel.isBound()) {
                PhysicalChannelConnection producerConnection = this.generateLocalConnection(consumer, channel, target, classLoader);
                connections.add(producerConnection);
                continue;
            }
            DeliveryType deliveryType = entry.getValue();
            PhysicalChannelConnection bindingConnection = this.generateDirectBoundConnection(consumer, channel, deliveryType, classLoader, target);
            connections.add(bindingConnection);
        }
        return connections;
    }

    private List<PhysicalChannelConnection> generateConnections(LogicalConsumer consumer, Map<LogicalChannel, DeliveryType> channels, PhysicalConnectionTarget target, ClassLoader classLoader) {
        ArrayList<PhysicalChannelConnection> connections = new ArrayList<PhysicalChannelConnection>();
        for (Map.Entry<LogicalChannel, DeliveryType> entry : channels.entrySet()) {
            PhysicalChannelConnection consumerConnection;
            LogicalChannel channel = entry.getKey();
            if (!channel.isBound()) {
                consumerConnection = this.generateLocalConnection(consumer, channel, target, classLoader);
                connections.add(consumerConnection);
                continue;
            }
            consumerConnection = this.generateLocalConnection(consumer, channel, target, classLoader);
            connections.add(consumerConnection);
            DeliveryType deliveryType = entry.getValue();
            PhysicalChannelConnection bindingDefinition = this.generateBoundConnection(consumer, channel, deliveryType, classLoader);
            connections.add(bindingDefinition);
        }
        return connections;
    }

    private List<PhysicalChannelConnection> generateDirectConnections(LogicalProducer producer, Map<LogicalChannel, DeliveryType> channels, PhysicalConnectionSource source, ClassLoader classLoader) {
        ArrayList<PhysicalChannelConnection> connections = new ArrayList<PhysicalChannelConnection>();
        Class type = producer.getDefinition().getServiceContract().getInterfaceClass();
        for (Map.Entry<LogicalChannel, DeliveryType> entry : channels.entrySet()) {
            LogicalChannel channel = entry.getKey();
            if (!channel.isBound()) {
                PhysicalChannelConnection producerConnection = this.generateLocalConnection(producer, type, channel, source, classLoader);
                connections.add(producerConnection);
                continue;
            }
            DeliveryType deliveryType = entry.getValue();
            PhysicalChannelConnection bindingConnection = this.generateDirectBoundConnection(producer, channel, deliveryType, classLoader, source);
            connections.add(bindingConnection);
        }
        return connections;
    }

    private List<PhysicalChannelConnection> generateConnections(LogicalProducer producer, Map<LogicalChannel, DeliveryType> channels, PhysicalConnectionSource source, ClassLoader classLoader) {
        ArrayList<PhysicalChannelConnection> connections = new ArrayList<PhysicalChannelConnection>();
        for (Map.Entry<LogicalChannel, DeliveryType> entry : channels.entrySet()) {
            LogicalChannel channel = entry.getKey();
            Class<?> type = this.getType(producer);
            if (!channel.isBound()) {
                PhysicalChannelConnection connection = this.generateLocalConnection(producer, type, channel, source, classLoader);
                connections.add(connection);
                continue;
            }
            PhysicalChannelConnection producerConnection = this.generateLocalConnection(producer, type, channel, source, classLoader);
            connections.add(producerConnection);
            DeliveryType deliveryType = entry.getValue();
            PhysicalChannelConnection bindingConnection = this.generateBoundConnection(producer, channel, deliveryType, classLoader);
            connections.add(bindingConnection);
        }
        return connections;
    }

    private boolean isDirect(LogicalInvocable invocable, Map<LogicalChannel, DeliveryType> channels) {
        boolean direct = false;
        if (!channels.isEmpty()) {
            LogicalChannel logicalChannel = channels.keySet().iterator().next();
            ServiceContract contract = invocable.getServiceContract();
            if (contract == null) {
                return false;
            }
            Class interfaceClass = contract.getInterfaceClass();
            if (logicalChannel.isBound()) {
                Binding binding = logicalChannel.getBinding().getDefinition();
                if (!binding.getConnectionTypes().isEmpty()) {
                    direct = binding.getConnectionTypes().stream().anyMatch(t -> t.isAssignableFrom(interfaceClass));
                }
            } else {
                Channel channel = logicalChannel.getDefinition();
                if (!channel.getConnectionTypes().isEmpty()) {
                    direct = channel.getConnectionTypes().stream().anyMatch(t -> t.isAssignableFrom(interfaceClass));
                }
            }
        }
        return direct;
    }

    private PhysicalChannelConnection generateLocalConnection(LogicalConsumer consumer, LogicalChannel channel, PhysicalConnectionTarget target, ClassLoader classLoader) {
        URI uri = channel.getUri();
        ChannelSource source = new ChannelSource(uri, ChannelSide.CONSUMER);
        source.setSequence(consumer.getDefinition().getSequence());
        source.setClassLoader(classLoader);
        Class<?> type = this.getType(consumer);
        boolean bound = channel.isBound();
        return new PhysicalChannelConnection(uri, consumer.getUri(), (PhysicalConnectionSource)source, target, type, bound);
    }

    private PhysicalChannelConnection generateBoundConnection(LogicalConsumer consumer, LogicalChannel channel, DeliveryType deliveryType, ClassLoader classLoader) {
        LogicalBinding binding = channel.getBinding();
        ConnectionBindingGenerator bindingGenerator = this.getGenerator(binding);
        PhysicalConnectionSource source = bindingGenerator.generateConnectionSource(consumer, binding, deliveryType);
        source.setSequence(consumer.getDefinition().getSequence());
        source.setClassLoader(classLoader);
        URI uri = channel.getUri();
        ChannelTarget target = new ChannelTarget(uri, ChannelSide.CONSUMER);
        target.setClassLoader(classLoader);
        Class<?> type = this.getType(consumer);
        return new PhysicalChannelConnection(uri, consumer.getUri(), source, (PhysicalConnectionTarget)target, type, true);
    }

    private PhysicalChannelConnection generateLocalConnection(LogicalProducer producer, Class<?> type, LogicalChannel channel, PhysicalConnectionSource source, ClassLoader classLoader) {
        URI uri = channel.getUri();
        ChannelTarget target = new ChannelTarget(uri, ChannelSide.PRODUCER);
        target.setClassLoader(classLoader);
        boolean bound = channel.isBound();
        return new PhysicalChannelConnection(uri, producer.getUri(), source, (PhysicalConnectionTarget)target, type, bound);
    }

    private PhysicalChannelConnection generateBoundConnection(LogicalProducer producer, LogicalChannel channel, DeliveryType deliveryType, ClassLoader classLoader) {
        LogicalBinding binding = channel.getBinding();
        ConnectionBindingGenerator bindingGenerator = this.getGenerator(binding);
        PhysicalConnectionTarget target = bindingGenerator.generateConnectionTarget(producer, binding, deliveryType);
        target.setClassLoader(classLoader);
        URI uri = channel.getUri();
        ChannelSource source = new ChannelSource(uri, ChannelSide.PRODUCER);
        source.setClassLoader(classLoader);
        boolean bound = channel.isBound();
        Class<?> type = this.getType(producer);
        return new PhysicalChannelConnection(uri, producer.getUri(), (PhysicalConnectionSource)source, target, type, bound);
    }

    private PhysicalChannelConnection generateDirectBoundConnection(LogicalConsumer consumer, LogicalChannel channel, DeliveryType deliveryType, ClassLoader classLoader, PhysicalConnectionTarget target) {
        LogicalBinding binding = channel.getBinding();
        ConnectionBindingGenerator bindingGenerator = this.getGenerator(binding);
        PhysicalConnectionSource source = bindingGenerator.generateConnectionSource(consumer, binding, deliveryType);
        source.setClassLoader(classLoader);
        URI uri = channel.getUri();
        Class<?> type = this.getType(consumer);
        return new PhysicalChannelConnection(uri, consumer.getUri(), source, target, type, true);
    }

    private PhysicalChannelConnection generateDirectBoundConnection(LogicalProducer producer, LogicalChannel channel, DeliveryType deliveryType, ClassLoader classLoader, PhysicalConnectionSource source) {
        LogicalBinding binding = channel.getBinding();
        ConnectionBindingGenerator bindingGenerator = this.getGenerator(binding);
        PhysicalConnectionTarget target = bindingGenerator.generateConnectionTarget(producer, binding, deliveryType);
        target.setClassLoader(classLoader);
        URI uri = channel.getUri();
        Class type = producer.getDefinition().getServiceContract().getInterfaceClass();
        return new PhysicalChannelConnection(uri, producer.getUri(), source, target, type, true);
    }

    private Class<?> getType(LogicalProducer producer) {
        Operation operation = producer.getStreamOperation().getDefinition();
        List params = operation.getInputTypes();
        if (params.size() != 1) {
            String interfaceName = producer.getServiceContract().getQualifiedInterfaceName();
            throw new Fabric3Exception("A channel interface must have one parameter: operation " + operation.getName() + " on " + interfaceName);
        }
        return ((DataType)params.get(0)).getType();
    }

    private Class<?> getType(LogicalConsumer consumer) {
        Consumer consumerDefinition = consumer.getDefinition();
        return consumerDefinition.getType().getType();
    }

    private <C extends LogicalComponent<?>> ComponentGenerator<C> getGenerator(C component) {
        Implementation implementation = component.getDefinition().getImplementation();
        return this.generatorRegistry.getComponentGenerator(implementation.getClass());
    }

    private <T extends Binding> ConnectionBindingGenerator<T> getGenerator(LogicalBinding<T> binding) {
        return this.generatorRegistry.getConnectionBindingGenerator(binding.getDefinition().getClass());
    }
}

