/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.domain.collector;

import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.fabric3.fabric.domain.collector.Collector;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.spi.model.instance.LogicalChannel;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalReference;
import org.fabric3.spi.model.instance.LogicalResource;
import org.fabric3.spi.model.instance.LogicalService;
import org.fabric3.spi.model.instance.LogicalState;
import org.fabric3.spi.model.instance.LogicalWire;

public class CollectorImpl
implements Collector {
    @Override
    public void markAsProvisioned(LogicalCompositeComponent composite) {
        for (LogicalComponent component : composite.getComponents()) {
            if (component instanceof LogicalCompositeComponent) {
                this.markAsProvisioned((LogicalCompositeComponent)component);
            }
            if (LogicalState.NEW == component.getState()) {
                component.setState(LogicalState.PROVISIONED);
            }
            for (LogicalService service : component.getServices()) {
                service.getBindings().stream().filter(binding -> LogicalState.NEW == binding.getState()).forEach(binding -> binding.setState(LogicalState.PROVISIONED));
                service.getCallbackBindings().stream().filter(binding -> LogicalState.NEW == binding.getState()).forEach(binding -> binding.setState(LogicalState.PROVISIONED));
            }
            for (LogicalReference reference : component.getReferences()) {
                reference.getBindings().stream().filter(binding -> LogicalState.NEW == binding.getState()).forEach(binding -> binding.setState(LogicalState.PROVISIONED));
                reference.getCallbackBindings().stream().filter(binding -> LogicalState.NEW == binding.getState()).forEach(binding -> binding.setState(LogicalState.PROVISIONED));
            }
        }
        for (List wires : composite.getWires().values()) {
            wires.stream().filter(wire -> LogicalState.NEW == wire.getState()).forEach(wire -> wire.setState(LogicalState.PROVISIONED));
        }
        for (LogicalChannel channel : composite.getChannels()) {
            LogicalBinding binding2;
            if (LogicalState.NEW == channel.getState()) {
                channel.setState(LogicalState.PROVISIONED);
            }
            if ((binding2 = channel.getBinding()) == null || LogicalState.NEW != binding2.getState()) continue;
            binding2.setState(LogicalState.PROVISIONED);
        }
        composite.getResources().stream().filter(resource -> LogicalState.NEW == resource.getState()).forEach(resource -> resource.setState(LogicalState.PROVISIONED));
    }

    @Override
    public void markForCollection(URI contributionUri, LogicalCompositeComponent composite) {
        for (LogicalComponent component : composite.getComponents()) {
            if (contributionUri.equals(component.getDefinition().getContributionUri())) {
                if (component.getDefinition() != null && !contributionUri.equals(component.getDefinition().getContributionUri())) continue;
                if (component instanceof LogicalCompositeComponent) {
                    this.markForCollection(contributionUri, (LogicalCompositeComponent)component);
                }
                component.setState(LogicalState.MARKED);
                for (LogicalService service : component.getServices()) {
                    for (LogicalBinding binding2 : service.getBindings()) {
                        binding2.setState(LogicalState.MARKED);
                    }
                }
                for (LogicalReference reference : component.getReferences()) {
                    for (LogicalBinding binding2 : reference.getBindings()) {
                        binding2.setState(LogicalState.MARKED);
                    }
                    for (LogicalWire wire : composite.getWires(reference)) {
                        wire.setState(LogicalState.MARKED);
                    }
                }
                continue;
            }
            for (LogicalService service : component.getServices()) {
                service.getBindings().stream().filter(binding -> contributionUri.equals(binding.getTargetContribution())).forEach(binding -> binding.setState(LogicalState.MARKED));
                service.getCallbackBindings().stream().filter(binding -> contributionUri.equals(binding.getTargetContribution())).forEach(binding -> binding.setState(LogicalState.MARKED));
            }
            for (List wires : composite.getWires().values()) {
                for (LogicalWire wire : wires) {
                    if (LogicalState.MARKED == wire.getState() || !contributionUri.equals(wire.getTargetContribution())) continue;
                    wire.setState(LogicalState.MARKED);
                }
            }
        }
        for (LogicalChannel channel : composite.getChannels()) {
            LogicalBinding binding3;
            if (channel.getDefinition() != null && !contributionUri.equals(channel.getDefinition().getContributionUri())) continue;
            if (contributionUri.equals(channel.getDefinition().getContributionUri())) {
                channel.setState(LogicalState.MARKED);
            }
            if ((binding3 = channel.getBinding()) == null || !contributionUri.equals(binding3.getTargetContribution())) continue;
            binding3.setState(LogicalState.MARKED);
        }
        for (LogicalResource resource : composite.getResources()) {
            if (!contributionUri.equals(resource.getDefinition().getContributionUri())) continue;
            resource.setState(LogicalState.MARKED);
        }
    }

    @Override
    public void collect(LogicalCompositeComponent composite) {
        Iterator iter = composite.getComponents().iterator();
        while (iter.hasNext()) {
            LogicalComponent component = (LogicalComponent)iter.next();
            if (LogicalState.MARKED == component.getState()) {
                iter.remove();
                continue;
            }
            for (LogicalService service : component.getServices()) {
                this.removeMarkedBindings(service.getBindings().iterator());
                this.removeMarkedBindings(service.getCallbackBindings().iterator());
            }
            for (LogicalReference reference : component.getReferences()) {
                this.removeMarkedBindings(reference.getBindings().iterator());
                this.removeMarkedBindings(reference.getCallbackBindings().iterator());
            }
            if (!(component instanceof LogicalCompositeComponent)) continue;
            this.collect((LogicalCompositeComponent)component);
        }
        ArrayList toRemove = new ArrayList();
        for (Map.Entry wires : composite.getWires().entrySet()) {
            Iterator it = ((List)wires.getValue()).iterator();
            while (it.hasNext()) {
                LogicalWire wire = (LogicalWire)it.next();
                if (LogicalState.MARKED != wire.getState()) continue;
                it.remove();
            }
            if (!((List)wires.getValue()).isEmpty()) continue;
            toRemove.add(wires.getKey());
        }
        for (LogicalReference reference : toRemove) {
            composite.getWires().remove(reference);
        }
        Iterator channelIter = composite.getChannels().iterator();
        while (channelIter.hasNext()) {
            LogicalChannel channel = (LogicalChannel)channelIter.next();
            if (LogicalState.MARKED != channel.getState()) continue;
            channelIter.remove();
        }
        Iterator resourceIter = composite.getResources().iterator();
        while (resourceIter.hasNext()) {
            LogicalResource resource = (LogicalResource)resourceIter.next();
            if (LogicalState.MARKED != resource.getState()) continue;
            resourceIter.remove();
        }
    }

    private void removeMarkedBindings(Iterator<LogicalBinding<?>> iter) {
        while (iter.hasNext()) {
            LogicalBinding<?> binding = iter.next();
            if (LogicalState.MARKED != binding.getState()) continue;
            iter.remove();
        }
    }
}

