/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.domain;

import java.util.List;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.model.type.component.Scope;
import org.fabric3.fabric.container.command.Command;
import org.fabric3.fabric.container.command.CommandExecutorRegistry;
import org.fabric3.fabric.domain.Deployer;
import org.fabric3.fabric.domain.generator.Deployment;
import org.fabric3.spi.container.component.ScopeRegistry;
import org.oasisopen.sca.annotation.Reference;

public class LocalDeployer
implements Deployer {
    private CommandExecutorRegistry executorRegistry;
    private ScopeRegistry scopeRegistry;

    public LocalDeployer(@Reference CommandExecutorRegistry executorRegistry, @Reference ScopeRegistry scopeRegistry) {
        this.executorRegistry = executorRegistry;
        this.scopeRegistry = scopeRegistry;
    }

    @Override
    public void deploy(Deployment deployment) throws Fabric3Exception {
        List<Command> commands = deployment.getCommands();
        this.execute(commands);
        if (this.scopeRegistry != null) {
            this.scopeRegistry.getScopeContainer(Scope.COMPOSITE).reinject();
        }
    }

    private void execute(List<Command> commands) throws Fabric3Exception {
        for (Command command : commands) {
            this.executorRegistry.execute(command);
        }
    }
}

