/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.domain;

import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.fabric3.api.host.contribution.Deployable;
import org.fabric3.api.host.runtime.HostInfo;
import org.fabric3.api.model.type.component.Composite;
import org.fabric3.fabric.domain.ContributionHelper;
import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.contribution.MetaDataStore;
import org.fabric3.spi.contribution.Resource;
import org.fabric3.spi.contribution.ResourceElement;
import org.fabric3.spi.contribution.manifest.QNameSymbol;
import org.oasisopen.sca.annotation.Reference;

public class ContributionHelperImpl
implements ContributionHelper {
    private MetaDataStore metadataStore;
    private HostInfo hostInfo;

    public ContributionHelperImpl(@Reference MetaDataStore metadataStore, @Reference HostInfo hostInfo) {
        this.metadataStore = metadataStore;
        this.hostInfo = hostInfo;
    }

    @Override
    public List<Composite> getDeployables(Set<Contribution> contributions) {
        ArrayList<Composite> deployables = new ArrayList<Composite>();
        for (Contribution contribution : contributions) {
            for (Resource resource : contribution.getResources()) {
                block2: for (ResourceElement entry : resource.getResourceElements()) {
                    if (!(entry.getValue() instanceof Composite)) continue;
                    ResourceElement element = entry;
                    QName name = (QName)((QNameSymbol)element.getSymbol()).getKey();
                    Composite composite = (Composite)element.getValue();
                    for (Deployable deployable : contribution.getManifest().getDeployables()) {
                        List environments;
                        if (!deployable.getName().equals(name)) continue;
                        List deployableModes = deployable.getRuntimeModes();
                        if (!deployableModes.contains(this.hostInfo.getRuntimeMode()) || !(environments = deployable.getEnvironments()).isEmpty() && !environments.contains(this.hostInfo.getEnvironment())) continue block2;
                        deployables.add(composite);
                        continue block2;
                    }
                }
            }
        }
        return deployables;
    }

    @Override
    public Set<Contribution> findContributions(List<URI> uris) {
        LinkedHashSet<Contribution> contributions = new LinkedHashSet<Contribution>(uris.size());
        for (URI uri : uris) {
            Contribution contribution = this.metadataStore.find(uri);
            if (contribution == null) {
                throw new AssertionError((Object)("Contribution not found for: " + uri));
            }
            contributions.add(contribution);
        }
        return contributions;
    }
}

