/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.contract;

import org.fabric3.api.model.type.java.Signature;
import org.fabric3.spi.contract.ContractMatcherExtension;
import org.fabric3.spi.contract.MatchResult;
import org.fabric3.spi.model.type.java.JavaServiceContract;

public class JavaContractMatcherExtension
implements ContractMatcherExtension<JavaServiceContract, JavaServiceContract> {
    public Class<JavaServiceContract> getSource() {
        return JavaServiceContract.class;
    }

    public Class<JavaServiceContract> getTarget() {
        return JavaServiceContract.class;
    }

    public MatchResult isAssignableFrom(JavaServiceContract source, JavaServiceContract target, boolean reportErrors) {
        if (source == target) {
            return MatchResult.MATCH;
        }
        if (source.getInterfaceClass().isAssignableFrom(target.getInterfaceClass())) {
            return MatchResult.MATCH;
        }
        if (source.getSuperType() == null && target.getSuperType() != null || source.getSuperType() != null && !source.getSuperType().equals(target.getSuperType())) {
            if (reportErrors) {
                return new MatchResult("Types are not in the same type hierarchy");
            }
            return MatchResult.NO_MATCH;
        }
        if (source.getQualifiedInterfaceName().equals(target.getQualifiedInterfaceName())) {
            for (Signature signature : source.getMethodSignatures()) {
                if (target.getMethodSignatures().contains(signature)) continue;
                if (reportErrors) {
                    return new MatchResult("Method signature not found on target service contract: " + signature);
                }
                return MatchResult.NO_MATCH;
            }
            return MatchResult.MATCH;
        }
        for (String superType : target.getInterfaces()) {
            if (!superType.equals(source.getInterfaceClass().getName())) continue;
            return MatchResult.MATCH;
        }
        if (!source.isRemotable() || !target.isRemotable()) {
            if (reportErrors) {
                return new MatchResult("Source and target interfaces do not match");
            }
            return MatchResult.NO_MATCH;
        }
        for (Signature signature : source.getMethodSignatures()) {
            if (target.getMethodSignatures().contains(signature)) continue;
            if (reportErrors) {
                return new MatchResult("Method signature not found on target service contract: " + signature);
            }
            return MatchResult.NO_MATCH;
        }
        return MatchResult.MATCH;
    }
}

