/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.container.wire;

import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.spi.container.invocation.Message;
import org.fabric3.spi.container.wire.Interceptor;
import org.fabric3.spi.transform.Transformer;
import org.oasisopen.sca.ServiceRuntimeException;

public class TransformerInterceptor
implements Interceptor {
    private Transformer<Object, Object> inTransformer;
    private Transformer<Object, Object> outTransformer;
    private ClassLoader inLoader;
    private ClassLoader outLoader;
    private Interceptor next;

    public TransformerInterceptor(Transformer<Object, Object> inTransformer, Transformer<Object, Object> outTransformer, ClassLoader inLoader, ClassLoader outLoader) {
        this.inTransformer = inTransformer;
        this.outTransformer = outTransformer;
        this.inLoader = inLoader;
        this.outLoader = outLoader;
    }

    public Message invoke(Message msg) {
        this.transformInput(msg);
        Message ret = this.next.invoke(msg);
        return this.transformOutput(ret);
    }

    private void transformInput(Message msg) {
        Object params = msg.getBody();
        if (params != null) {
            try {
                if (params.getClass().isArray() && ((Object[])params).length == 1) {
                    Object[] paramArray = (Object[])params;
                    paramArray[0] = this.inTransformer.transform(paramArray[0], this.inLoader);
                } else {
                    Object transformed = this.inTransformer.transform(params, this.inLoader);
                    msg.setBody(transformed);
                }
            }
            catch (Fabric3Exception e) {
                throw new ServiceRuntimeException((Throwable)e);
            }
        }
    }

    private Message transformOutput(Message ret) {
        Object body = ret.getBody();
        if (body != null) {
            try {
                Object transformed = this.outTransformer.transform(body, this.outLoader);
                if (ret.isFault()) {
                    ret.setBodyWithFault(transformed);
                } else {
                    ret.setBody(transformed);
                }
            }
            catch (ClassCastException e) {
                if (body instanceof Throwable) {
                    throw new ServiceRuntimeException("Unexpected exception returned", (Throwable)body);
                }
                throw new ServiceRuntimeException("Unexpected type returned: " + body.getClass());
            }
            catch (Fabric3Exception e) {
                throw new ServiceRuntimeException((Throwable)e);
            }
        }
        return ret;
    }

    public void setNext(Interceptor next) {
        this.next = next;
    }

    public Interceptor getNext() {
        return this.next;
    }
}

