/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.container.component;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.model.type.component.Scope;
import org.fabric3.fabric.container.component.AbstractScopeContainer;
import org.fabric3.fabric.container.component.ScopeContainerMonitor;
import org.fabric3.spi.container.component.GroupInitializationException;
import org.fabric3.spi.container.component.ScopedComponent;
import org.oasisopen.sca.annotation.Destroy;

public abstract class SingletonScopeContainer
extends AbstractScopeContainer {
    private static final Object EMPTY = new Object();
    private final Map<ScopedComponent, Object> instances;
    private final Map<URI, List<Pair>> destroyQueues;
    private final Map<URI, List<ScopedComponent>> initQueues = new HashMap<URI, List<ScopedComponent>>();
    private final Map<ScopedComponent, CountDownLatch> pending;

    protected SingletonScopeContainer(Scope scope, @Monitor ScopeContainerMonitor monitor) {
        super(scope, monitor);
        this.instances = new ConcurrentHashMap<ScopedComponent, Object>();
        this.pending = new ConcurrentHashMap<ScopedComponent, CountDownLatch>();
        this.destroyQueues = new LinkedHashMap<URI, List<Pair>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(ScopedComponent component) {
        super.register(component);
        if (component.isEagerInit()) {
            URI uri = component.getContributionUri();
            Map<URI, List<ScopedComponent>> map = this.initQueues;
            synchronized (map) {
                List<ScopedComponent> initQueue = this.initQueues.get(uri);
                if (initQueue == null) {
                    initQueue = new ArrayList<ScopedComponent>();
                    this.initQueues.put(uri, initQueue);
                }
                initQueue.add(component);
            }
        }
        this.instances.put(component, EMPTY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(ScopedComponent component) {
        super.unregister(component);
        this.instances.remove(component);
        if (component.isEagerInit()) {
            URI uri = component.getContributionUri();
            Map<URI, List<ScopedComponent>> map = this.initQueues;
            synchronized (map) {
                List<ScopedComponent> initQueue = this.initQueues.get(uri);
                initQueue.remove(component);
                if (initQueue.isEmpty()) {
                    this.initQueues.remove(uri);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startContext(URI contribution) throws GroupInitializationException {
        this.eagerInitialize(contribution);
        Map<URI, List<Pair>> map = this.destroyQueues;
        synchronized (map) {
            if (!this.destroyQueues.containsKey(contribution)) {
                this.destroyQueues.put(contribution, new ArrayList());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopContext(URI contribution) {
        Map<URI, List<Pair>> map = this.destroyQueues;
        synchronized (map) {
            List<Pair> list = this.destroyQueues.get(contribution);
            if (list == null) {
                return;
            }
            this.destroyInstances(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Destroy
    public synchronized void stop() {
        super.stop();
        Map<URI, List<Pair>> map = this.destroyQueues;
        synchronized (map) {
            this.destroyQueues.clear();
        }
        map = this.initQueues;
        synchronized (map) {
            this.initQueues.clear();
        }
        this.instances.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getInstance(ScopedComponent component) {
        CountDownLatch latch;
        Object instance = this.instances.get(component);
        if (instance != EMPTY && instance != null) {
            return instance;
        }
        ScopedComponent scopedComponent = component;
        synchronized (scopedComponent) {
            latch = this.pending.get(component);
            if (latch != null) {
                try {
                    latch.await(5L, TimeUnit.MINUTES);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new Fabric3Exception("Error creating instance for: " + component.getUri(), (Throwable)e);
                }
                return this.instances.get(component);
            }
            latch = new CountDownLatch(1);
            this.pending.put(component, latch);
        }
        try {
            List<Pair> queue;
            instance = component.createInstance();
            component.startInstance(instance);
            URI uri = component.getContributionUri();
            Object object = this.destroyQueues;
            synchronized (object) {
                queue = this.destroyQueues.get(uri);
                if (queue == null) {
                    queue = new ArrayList<Pair>();
                    this.destroyQueues.put(uri, queue);
                }
            }
            queue.add(new Pair(component, instance));
            this.instances.put(component, instance);
            latch.countDown();
            object = instance;
            return object;
        }
        finally {
            this.pending.remove(component);
        }
    }

    public void releaseInstance(ScopedComponent component, Object instance) {
    }

    public List<Object> getActiveInstances(ScopedComponent component) {
        Object instance = this.instances.get(component);
        if (instance == null || instance == EMPTY) {
            return Collections.emptyList();
        }
        return Collections.singletonList(instance);
    }

    public void reinject() {
        for (Map.Entry<ScopedComponent, Object> entry : this.instances.entrySet()) {
            ScopedComponent component = entry.getKey();
            Object instance = entry.getValue();
            component.reinject(instance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAllContexts() {
        Map<URI, List<Pair>> map = this.destroyQueues;
        synchronized (map) {
            ArrayList<List<Pair>> queues = new ArrayList<List<Pair>>(this.destroyQueues.values());
            ListIterator iter = queues.listIterator(queues.size());
            while (iter.hasPrevious()) {
                List queue = (List)iter.previous();
                this.destroyInstances(queue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void eagerInitialize(URI contextUri) {
        List<ScopedComponent> initQueue;
        Map<URI, List<ScopedComponent>> map = this.initQueues;
        synchronized (map) {
            initQueue = this.initQueues.get(contextUri);
            if (initQueue != null) {
                initQueue = new ArrayList<ScopedComponent>(initQueue);
            }
        }
        if (initQueue != null) {
            this.initializeComponents(initQueue);
        }
    }

    private void initializeComponents(List<ScopedComponent> components) throws GroupInitializationException {
        LinkedHashSet<URI> causes = null;
        for (ScopedComponent component : components) {
            try {
                this.getInstance(component);
            }
            catch (Exception e) {
                if (causes == null) {
                    causes = new LinkedHashSet<URI>();
                }
                URI uri = component.getUri();
                this.monitor.initializationError(uri, component.getContributionUri(), e);
                causes.add(uri);
            }
        }
        if (causes != null) {
            throw new GroupInitializationException(causes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyInstances(List<Pair> instances) {
        while (true) {
            Pair toDestroy;
            List<Pair> list = instances;
            synchronized (list) {
                if (instances.size() == 0) {
                    return;
                }
                toDestroy = instances.remove(instances.size() - 1);
            }
            ScopedComponent component = toDestroy.component;
            try {
                Object instance = toDestroy.instance;
                component.stopInstance(instance);
                continue;
            }
            catch (Fabric3Exception e) {
                this.monitor.destructionError(component.getUri(), component.getContributionUri(), e);
                continue;
            }
            break;
        }
    }

    private class Pair {
        private ScopedComponent component;
        private Object instance;

        private Pair(ScopedComponent component, Object instance) {
            this.component = component;
            this.instance = instance;
        }
    }
}

