/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.container.command;

import java.net.URI;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.api.model.type.component.Scope;
import org.fabric3.fabric.container.channel.ChannelManager;
import org.fabric3.fabric.container.command.CommandExecutor;
import org.fabric3.fabric.container.command.CommandExecutorRegistry;
import org.fabric3.fabric.container.command.ContextMonitor;
import org.fabric3.fabric.container.command.StartContextCommand;
import org.fabric3.spi.container.component.ScopeContainer;
import org.fabric3.spi.container.component.ScopeRegistry;
import org.fabric3.spi.container.invocation.WorkContextCache;
import org.oasisopen.sca.annotation.Constructor;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class StartContextCommandExecutor
implements CommandExecutor<StartContextCommand> {
    private CommandExecutorRegistry commandExecutorRegistry;
    private ScopeRegistry scopeRegistry;
    private ChannelManager channelManager;
    private ContextMonitor monitor;

    @Constructor
    public StartContextCommandExecutor(@Reference CommandExecutorRegistry executorRegistry, @Reference ScopeRegistry scopeRegistry, @Reference ChannelManager channelManager, @Monitor ContextMonitor monitor) {
        this.commandExecutorRegistry = executorRegistry;
        this.scopeRegistry = scopeRegistry;
        this.channelManager = channelManager;
        this.monitor = monitor;
    }

    public StartContextCommandExecutor(ScopeRegistry scopeRegistry, @Monitor ContextMonitor monitor) {
        this(null, scopeRegistry, null, monitor);
    }

    @Init
    public void init() {
        this.commandExecutorRegistry.register(StartContextCommand.class, this);
    }

    @Override
    public void execute(StartContextCommand command) {
        URI uri = command.getUri();
        WorkContextCache.getAndResetThreadWorkContext();
        if (this.channelManager != null) {
            this.channelManager.startContext(uri);
        }
        ScopeContainer compositeScopeContainer = this.scopeRegistry.getScopeContainer(Scope.COMPOSITE);
        ScopeContainer domainScopeContainer = this.scopeRegistry.getScopeContainer(Scope.DOMAIN);
        compositeScopeContainer.startContext(uri);
        if (domainScopeContainer != null) {
            domainScopeContainer.startContext(uri);
        }
        if (command.isLog()) {
            this.monitor.deployed(uri);
        }
    }
}

