/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.container.command;

import java.util.Map;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.fabric.container.command.CommandExecutor;
import org.fabric3.fabric.container.command.CommandExecutorRegistry;
import org.fabric3.fabric.container.command.DisposeResourcesCommand;
import org.fabric3.spi.container.builder.ResourceBuilder;
import org.fabric3.spi.model.physical.PhysicalResource;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class DisposeResourcesCommandExecutor
implements CommandExecutor<DisposeResourcesCommand> {
    private Map<Class<?>, ResourceBuilder> builders;
    private CommandExecutorRegistry executorRegistry;

    public DisposeResourcesCommandExecutor(@Reference CommandExecutorRegistry registry) {
        this.executorRegistry = registry;
    }

    @Reference(required=false)
    public void setBuilders(Map<Class<?>, ResourceBuilder> builders) {
        this.builders = builders;
    }

    @Override
    public void execute(DisposeResourcesCommand command) throws Fabric3Exception {
        command.getPhysicalResources().forEach(this::build);
    }

    @Init
    public void init() {
        this.executorRegistry.register(DisposeResourcesCommand.class, this);
    }

    public void build(PhysicalResource physicalResource) {
        ResourceBuilder builder = this.builders.get(physicalResource.getClass());
        if (builder == null) {
            throw new Fabric3Exception("Builder not found for " + physicalResource.getClass().getName());
        }
        builder.remove(physicalResource);
    }
}

