/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.container.command;

import java.util.HashMap;
import java.util.Map;
import org.fabric3.fabric.container.command.Command;
import org.fabric3.fabric.container.command.CommandExecutor;
import org.fabric3.fabric.container.command.CommandExecutorRegistry;
import org.oasisopen.sca.annotation.EagerInit;

@EagerInit
public class CommandExecutorRegistryImpl
implements CommandExecutorRegistry {
    private Map<Class<? extends Command>, CommandExecutor<?>> executors = new HashMap();

    @Override
    public <T extends Command> void register(Class<T> type, CommandExecutor<T> executor) {
        this.executors.put(type, executor);
    }

    @Override
    public <T extends Command> void execute(T command) {
        Class<?> clazz = command.getClass();
        CommandExecutor<?> executor = this.executors.get(clazz);
        if (executor == null) {
            throw new AssertionError((Object)("No registered executor for command: " + clazz.getName()));
        }
        executor.execute(command);
    }
}

