/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.container.command;

import java.util.Map;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.fabric.container.command.BuildResourcesCommand;
import org.fabric3.fabric.container.command.CommandExecutor;
import org.fabric3.fabric.container.command.CommandExecutorRegistry;
import org.fabric3.spi.container.builder.ResourceBuilder;
import org.fabric3.spi.model.physical.PhysicalResource;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class BuildResourcesCommandExecutor
implements CommandExecutor<BuildResourcesCommand> {
    private CommandExecutorRegistry executorRegistry;
    private Map<Class<?>, ResourceBuilder> builders;

    public BuildResourcesCommandExecutor(@Reference CommandExecutorRegistry registry) {
        this.executorRegistry = registry;
    }

    @Reference(required=false)
    public void setBuilders(Map<Class<?>, ResourceBuilder> builders) {
        this.builders = builders;
    }

    @Init
    public void init() {
        this.executorRegistry.register(BuildResourcesCommand.class, this);
    }

    @Override
    public void execute(BuildResourcesCommand command) throws Fabric3Exception {
        command.getPhysicalResources().forEach(this::build);
    }

    private void build(PhysicalResource physicalResource) {
        ResourceBuilder builder = this.builders.get(physicalResource.getClass());
        if (builder == null) {
            throw new Fabric3Exception("Builder not found for " + physicalResource.getClass().getName());
        }
        builder.build(physicalResource);
    }
}

