/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.container.channel;

import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.fabric.container.channel.ChannelManager;
import org.fabric3.spi.container.channel.Channel;
import org.fabric3.spi.model.physical.ChannelSide;

public class ChannelManagerImpl
implements ChannelManager {
    private Map<URI, Holder> collocatedChannels = new ConcurrentHashMap<URI, Holder>();
    private Map<URI, Holder> producerChannels = new ConcurrentHashMap<URI, Holder>();
    private Map<URI, Holder> consumerChannels = new ConcurrentHashMap<URI, Holder>();
    private boolean started;

    @Override
    public Channel getChannel(URI uri, ChannelSide channelSide) {
        this.checkUri(uri);
        Holder holder = this.getHolder(uri, channelSide);
        return holder != null ? holder.channel : null;
    }

    @Override
    public Channel getAndIncrementChannel(URI uri, ChannelSide channelSide) {
        this.checkUri(uri);
        Holder holder = this.getHolder(uri, channelSide);
        if (holder == null) {
            return null;
        }
        holder.counter.incrementAndGet();
        return holder.channel;
    }

    @Override
    public Channel getAndDecrementChannel(URI uri, ChannelSide channelSide) {
        this.checkUri(uri);
        Holder holder = this.getHolder(uri, channelSide);
        if (holder == null) {
            return null;
        }
        holder.counter.decrementAndGet();
        return holder.channel;
    }

    @Override
    public int getCount(URI uri, ChannelSide channelSide) {
        this.checkUri(uri);
        Holder holder = this.getHolder(uri, channelSide);
        if (holder == null) {
            return -1;
        }
        return holder.counter.get();
    }

    @Override
    public void register(Channel channel) throws Fabric3Exception {
        ChannelSide channelSide;
        if (this.started) {
            channel.start();
        }
        if (ChannelSide.COLLOCATED == (channelSide = channel.getChannelSide())) {
            this.checkAndPut(channel, this.collocatedChannels);
        } else if (ChannelSide.CONSUMER == channelSide) {
            this.checkAndPut(channel, this.consumerChannels);
        } else if (ChannelSide.PRODUCER == channelSide) {
            this.checkAndPut(channel, this.producerChannels);
        }
    }

    @Override
    public Channel unregister(URI uri, ChannelSide channelSide) {
        Holder holder = null;
        switch (channelSide) {
            case CONSUMER: {
                holder = this.consumerChannels.remove(uri);
                break;
            }
            case PRODUCER: {
                holder = this.producerChannels.remove(uri);
                break;
            }
            case COLLOCATED: {
                holder = this.collocatedChannels.remove(uri);
            }
        }
        if (holder == null) {
            return null;
        }
        return holder.channel;
    }

    @Override
    public void startContext(URI uri) {
        this.doStart(uri, this.collocatedChannels);
        this.doStart(uri, this.consumerChannels);
        this.doStart(uri, this.producerChannels);
    }

    @Override
    public void stopContext(URI uri) {
        this.doStop(uri, this.producerChannels);
        this.doStop(uri, this.consumerChannels);
        this.doStop(uri, this.collocatedChannels);
    }

    private void checkUri(URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException("Channel URI was null");
        }
    }

    private Holder getHolder(URI uri, ChannelSide channelSide) {
        Holder holder;
        Holder holder2 = holder = ChannelSide.CONSUMER == channelSide ? this.consumerChannels.get(uri) : this.producerChannels.get(uri);
        if (holder == null) {
            holder = this.collocatedChannels.get(uri);
        }
        return holder;
    }

    private void checkAndPut(Channel channel, Map<URI, Holder> map) throws Fabric3Exception {
        URI uri = channel.getUri();
        if (map.put(uri, new Holder(channel)) != null) {
            throw new Fabric3Exception("Channel already exists: " + uri);
        }
    }

    private void doStart(URI uri, Map<URI, Holder> map) {
        this.started = true;
        map.values().stream().filter(holder -> uri.equals(((Holder)holder).channel.getContributionUri())).forEach(holder -> ((Holder)holder).channel.start());
    }

    private void doStop(URI uri, Map<URI, Holder> map) {
        map.values().stream().filter(holder -> uri.equals(((Holder)holder).channel.getContributionUri())).forEach(holder -> ((Holder)holder).channel.stop());
        this.started = false;
    }

    private class Holder {
        private Channel channel;
        private AtomicInteger counter = new AtomicInteger(1);

        private Holder(Channel channel) {
            this.channel = channel;
        }
    }
}

