/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.container.channel;

import java.util.Optional;
import java.util.function.Supplier;
import org.fabric3.spi.container.channel.ChannelConnection;
import org.fabric3.spi.container.channel.EventStream;
import org.fabric3.spi.util.Cast;
import org.fabric3.spi.util.Closeable;

public class ChannelConnectionImpl
implements ChannelConnection {
    private String topic;
    private int sequence;
    private EventStream stream;
    private Closeable closeable;
    private Optional<Supplier<?>> directConnection = Optional.empty();

    public ChannelConnectionImpl(EventStream stream, String topic, int sequence) {
        this.stream = stream;
        this.topic = topic;
        this.sequence = sequence;
    }

    public ChannelConnectionImpl(Supplier<?> directConnection, String topic, int sequence) {
        this.directConnection = Optional.of(directConnection);
        this.topic = topic;
        this.sequence = sequence;
    }

    public int getSequence() {
        return this.sequence;
    }

    public EventStream getEventStream() {
        return this.stream;
    }

    public <T> Optional<Supplier<T>> getDirectConnection() {
        return (Optional)Cast.cast(this.directConnection);
    }

    public Closeable getCloseable() {
        return this.closeable;
    }

    public void setCloseable(Closeable closeable) {
        this.closeable = closeable;
    }

    public String getTopic() {
        return this.topic;
    }
}

