/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.container.builder.channel;

import java.net.URI;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.fabric.container.channel.ChannelManager;
import org.fabric3.fabric.model.physical.ChannelTarget;
import org.fabric3.spi.container.builder.TargetConnectionAttacher;
import org.fabric3.spi.container.channel.Channel;
import org.fabric3.spi.container.channel.ChannelConnection;
import org.fabric3.spi.model.physical.ChannelSide;
import org.fabric3.spi.model.physical.PhysicalConnectionSource;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class ChannelTargetAttacher
implements TargetConnectionAttacher<ChannelTarget> {
    private ChannelManager channelManager;

    public ChannelTargetAttacher(@Reference ChannelManager channelManager) {
        this.channelManager = channelManager;
    }

    public void attach(PhysicalConnectionSource source, ChannelTarget target, ChannelConnection connection) {
        if (source.isDirectConnection()) {
            return;
        }
        URI uri = target.getUri();
        Channel channel = this.getChannel(uri, target.getChannelSide());
        channel.attach(connection);
        connection.setCloseable(() -> {});
    }

    public void detach(PhysicalConnectionSource source, ChannelTarget target) {
    }

    private Channel getChannel(URI uri, ChannelSide channelSide) {
        Channel channel = this.channelManager.getChannel(uri, channelSide);
        if (channel == null) {
            throw new Fabric3Exception("Channel not found");
        }
        return channel;
    }
}

