/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.classloader;

import java.io.IOException;
import java.net.URI;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.spi.classloader.ClassLoaderRegistry;

public class ClassLoaderRegistryImpl
implements ClassLoaderRegistry {
    private Map<URI, ClassLoader> registry = new ConcurrentHashMap<URI, ClassLoader>();

    public synchronized void register(URI id, ClassLoader classLoader) {
        if (this.registry.containsKey(id)) {
            throw new Fabric3Exception("Duplicate classloader: " + id);
        }
        this.registry.put(id, classLoader);
    }

    public ClassLoader unregister(URI id) {
        return this.registry.remove(id);
    }

    public ClassLoader getClassLoader(URI id) {
        return this.registry.get(id);
    }

    public void close() {
        if (this.registry == null || this.registry.isEmpty()) {
            return;
        }
        Collection<ClassLoader> classLoaders = this.registry.values();
        for (ClassLoader classLoader : classLoaders) {
            if (!(classLoader instanceof URLClassLoader)) continue;
            try {
                ((URLClassLoader)classLoader).close();
            }
            catch (IOException e) {
                throw new Fabric3Exception((Throwable)e);
            }
        }
    }
}

