/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.channel.introspection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.fabric3.api.ChannelContext;
import org.fabric3.api.annotation.Channel;
import org.fabric3.api.annotation.wire.Key;
import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.api.model.type.component.ComponentType;
import org.fabric3.api.model.type.component.ResourceReference;
import org.fabric3.api.model.type.contract.ServiceContract;
import org.fabric3.api.model.type.java.InjectingComponentType;
import org.fabric3.api.model.type.java.InjectionSite;
import org.fabric3.channel.introspection.InvalidChannelContextType;
import org.fabric3.channel.model.ChannelResourceReference;
import org.fabric3.spi.introspection.DefaultIntrospectionContext;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.java.IntrospectionHelper;
import org.fabric3.spi.introspection.java.annotation.AbstractAnnotationProcessor;
import org.fabric3.spi.introspection.java.contract.JavaContractProcessor;
import org.fabric3.spi.model.type.java.ConstructorInjectionSite;
import org.fabric3.spi.model.type.java.FieldInjectionSite;
import org.fabric3.spi.model.type.java.MethodInjectionSite;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
@Key(value="org.fabric3.api.annotation.Channel")
public class ChannelAnnotationProcessor
extends AbstractAnnotationProcessor<Channel> {
    private ServiceContract contextContract;
    private IntrospectionHelper helper;

    public ChannelAnnotationProcessor(@Reference JavaContractProcessor contractProcessor, @Reference IntrospectionHelper helper) {
        super(Channel.class);
        this.helper = helper;
        DefaultIntrospectionContext context = new DefaultIntrospectionContext();
        this.contextContract = contractProcessor.introspect(ChannelContext.class, (IntrospectionContext)context, new ModelObject[0]);
        assert (!context.hasErrors());
    }

    public void visitConstructorParameter(Channel annotation, Constructor<?> constructor, int index, Class<?> implClass, InjectingComponentType componentType, IntrospectionContext context) {
        ConstructorInjectionSite site = new ConstructorInjectionSite(constructor, index);
        String name = this.helper.getSiteName(constructor, index, null);
        Class<?> type = constructor.getParameterTypes()[index];
        this.createReference(name, annotation, type, componentType, (InjectionSite)site, implClass, context);
    }

    public void visitField(Channel annotation, Field field, Class<?> implClass, InjectingComponentType componentType, IntrospectionContext context) {
        FieldInjectionSite site = new FieldInjectionSite(field);
        String name = this.helper.getSiteName(field, null);
        Class<?> type = field.getType();
        this.createReference(name, annotation, type, componentType, (InjectionSite)site, implClass, context);
    }

    public void visitMethod(Channel annotation, Method method, Class<?> implClass, InjectingComponentType componentType, IntrospectionContext context) {
        MethodInjectionSite site = new MethodInjectionSite(method, 0);
        String name = this.helper.getSiteName(method, null);
        Class<?> type = method.getParameterTypes()[0];
        this.createReference(name, annotation, type, componentType, (InjectionSite)site, implClass, context);
    }

    private void createReference(String name, Channel annotation, Class<?> type, InjectingComponentType componentType, InjectionSite site, Class<?> implClass, IntrospectionContext context) {
        if (ChannelContext.class.equals(type)) {
            String channelName = annotation.value();
            ChannelResourceReference reference = new ChannelResourceReference(name, channelName, this.contextContract);
            componentType.add((ResourceReference)reference, site);
        } else {
            String message = "Invalid channel context type " + type.getName() + " on " + implClass.getName();
            InvalidChannelContextType error = new InvalidChannelContextType(message, null, (ComponentType)componentType);
            context.addError((ValidationFailure)error);
        }
    }
}

