/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.channel.impl;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.channel.impl.AbstractFanOutHandler;
import org.fabric3.channel.impl.AsyncFanOutHandler;
import org.fabric3.channel.impl.FanOutHandler;
import org.fabric3.channel.impl.SyncFanOutHandler;
import org.fabric3.spi.container.channel.Channel;
import org.fabric3.spi.container.channel.ChannelConnection;
import org.fabric3.spi.container.channel.EventStream;
import org.fabric3.spi.container.channel.EventStreamHandler;
import org.fabric3.spi.container.channel.PassThroughHandler;
import org.fabric3.spi.model.physical.ChannelSide;

public class DefaultChannelImpl
implements Channel {
    private URI uri;
    private URI contributionUri;
    private ExecutorService executorService;
    private final ChannelSide channelSide;
    private TopicHandlers defaultTopicHandlers;
    private Map<String, TopicHandlers> handlerMap = new HashMap<String, TopicHandlers>();

    public DefaultChannelImpl(URI uri, ChannelSide channelSide, URI contributionUri) {
        this.uri = uri;
        this.channelSide = channelSide;
        this.contributionUri = contributionUri;
        SyncFanOutHandler fanOutHandler = new SyncFanOutHandler();
        this.defaultTopicHandlers = new TopicHandlers(fanOutHandler, null);
    }

    public DefaultChannelImpl(URI uri, ChannelSide channelSide, URI contributionUri, ExecutorService executorService) {
        this.uri = uri;
        this.channelSide = channelSide;
        this.contributionUri = contributionUri;
        this.executorService = executorService;
        AsyncFanOutHandler fanOutHandler = new AsyncFanOutHandler(executorService);
        this.defaultTopicHandlers = new TopicHandlers(fanOutHandler, null);
    }

    public URI getUri() {
        return this.uri;
    }

    public URI getContributionUri() {
        return this.contributionUri;
    }

    public void start() {
    }

    public void stop() {
    }

    public void addHandler(EventStreamHandler handler) {
        if (this.defaultTopicHandlers.headHandler == null) {
            this.defaultTopicHandlers.headHandler = handler;
            this.defaultTopicHandlers.inHandler.setNext(handler);
        } else {
            this.defaultTopicHandlers.tailHandler.setNext(handler);
        }
        this.defaultTopicHandlers.tailHandler = handler;
        this.defaultTopicHandlers.tailHandler.setNext((EventStreamHandler)this.defaultTopicHandlers.fanOutHandler);
    }

    public void removeHandler(EventStreamHandler handler) {
        EventStreamHandler previous = null;
        for (EventStreamHandler current = this.defaultTopicHandlers.headHandler; current != null; current = current.getNext()) {
            if (current == handler) {
                if (this.defaultTopicHandlers.headHandler == current) {
                    this.defaultTopicHandlers.headHandler = current.getNext();
                }
                if (this.defaultTopicHandlers.tailHandler == current) {
                    EventStreamHandler eventStreamHandler = this.defaultTopicHandlers.tailHandler = previous == null ? this.defaultTopicHandlers.headHandler : previous;
                }
                if (previous != null) {
                    previous.setNext(current.getNext());
                }
                this.defaultTopicHandlers.inHandler.setNext(this.defaultTopicHandlers.headHandler);
                return;
            }
            previous = current;
        }
    }

    public void attach(EventStreamHandler handler) {
        handler.setNext(this.defaultTopicHandlers.inHandler);
    }

    public void attach(ChannelConnection connection) {
        EventStream stream = connection.getEventStream();
        String topic = connection.getTopic();
        TopicHandlers topicHandlers = this.getTopicHandlers(topic, true);
        stream.getTailHandler().setNext(topicHandlers.inHandler);
    }

    public void subscribe(URI uri, ChannelConnection connection) {
        String topic = connection.getTopic();
        TopicHandlers topicHandlers = this.getTopicHandlers(topic, true);
        topicHandlers.fanOutHandler.addConnection(uri, connection);
    }

    public ChannelConnection unsubscribe(URI uri, String topic) {
        return this.getTopicHandlers((String)topic, (boolean)false).fanOutHandler.removeConnection(uri);
    }

    public ChannelSide getChannelSide() {
        return this.channelSide;
    }

    public Object getDirectConnection(String topic) {
        return this.getTopicHandlers((String)topic, (boolean)true).headHandler;
    }

    private TopicHandlers getTopicHandlers(String topic, boolean create) {
        if (topic == null) {
            return this.defaultTopicHandlers;
        }
        TopicHandlers topicHandlers = this.handlerMap.get(topic);
        if (topicHandlers == null) {
            if (create) {
                AbstractFanOutHandler fanOutHandler = this.executorService != null ? new AsyncFanOutHandler(this.executorService) : new SyncFanOutHandler();
                topicHandlers = new TopicHandlers(fanOutHandler, topic);
                this.handlerMap.put(topic, topicHandlers);
            } else {
                throw new Fabric3Exception("Handlers not registered for topic: " + topic);
            }
        }
        return topicHandlers;
    }

    private class TopicHandlers {
        String topic;
        EventStreamHandler inHandler;
        FanOutHandler fanOutHandler;
        EventStreamHandler headHandler;
        EventStreamHandler tailHandler;

        public TopicHandlers(FanOutHandler fanOutHandler, String topic) {
            this.topic = topic;
            this.inHandler = new PassThroughHandler();
            this.fanOutHandler = fanOutHandler;
            this.inHandler.setNext((EventStreamHandler)this.fanOutHandler);
        }
    }
}

