/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.channel.impl;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.fabric3.channel.impl.FanOutHandler;
import org.fabric3.spi.container.channel.ChannelConnection;
import org.fabric3.spi.container.channel.EventStreamHandler;

public abstract class AbstractFanOutHandler
implements FanOutHandler {
    protected Map<URI, ChannelConnection> connectionMap = new HashMap<URI, ChannelConnection>();
    protected Map<URI, AtomicInteger> counterMap = new HashMap<URI, AtomicInteger>();
    protected ChannelConnection[] connections = new ChannelConnection[0];

    @Override
    public synchronized void addConnection(URI uri, ChannelConnection connection) {
        AtomicInteger count = this.counterMap.get(uri);
        if (count == null) {
            count = new AtomicInteger(1);
            this.counterMap.put(uri, count);
            this.connectionMap.put(uri, connection);
            this.connections = this.connectionMap.values().toArray(new ChannelConnection[this.connectionMap.size()]);
        } else {
            count.incrementAndGet();
        }
    }

    @Override
    public synchronized ChannelConnection removeConnection(URI uri) {
        int count = this.counterMap.get(uri).decrementAndGet();
        if (count == 0) {
            this.counterMap.remove(uri);
            ChannelConnection connection = this.connectionMap.remove(uri);
            this.connections = this.connectionMap.values().toArray(new ChannelConnection[this.connectionMap.size()]);
            return connection;
        }
        return this.connectionMap.get(uri);
    }

    public void setNext(EventStreamHandler next) {
        throw new IllegalStateException("This handler must be the last one in the handler sequence");
    }

    public EventStreamHandler getNext() {
        return null;
    }
}

