/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution.scanner.impl;

import java.io.File;
import org.fabric3.contribution.scanner.impl.DirectoryResource;
import org.fabric3.contribution.scanner.spi.FileResource;
import org.fabric3.contribution.scanner.spi.FileSystemResource;
import org.fabric3.contribution.scanner.spi.FileSystemResourceFactory;
import org.fabric3.contribution.scanner.spi.FileSystemResourceFactoryRegistry;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class ExplodedJarResourceFactory
implements FileSystemResourceFactory {
    public ExplodedJarResourceFactory(@Reference FileSystemResourceFactoryRegistry registry) {
        registry.register(this);
    }

    @Override
    public FileSystemResource createResource(File file) {
        if (!file.isDirectory()) {
            return null;
        }
        File manifest = new File(file, "/META-INF/sca-contribution.xml");
        if (!manifest.exists()) {
            return null;
        }
        DirectoryResource directoryResource = new DirectoryResource(file);
        File metaInf = new File(file, "/META-INF");
        this.monitorResource(directoryResource, metaInf);
        return directoryResource;
    }

    private void monitorResource(DirectoryResource directoryResource, File file) {
        if (file.isDirectory()) {
            for (File entry : file.listFiles()) {
                if (entry.isFile()) {
                    directoryResource.addResource(new FileResource(entry));
                    continue;
                }
                this.monitorResource(directoryResource, entry);
            }
        } else {
            directoryResource.addResource(new FileResource(file));
        }
    }
}

