/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.xml.template;

import java.net.URI;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.introspection.xml.template.DuplicateTemplate;
import org.fabric3.introspection.xml.template.InvalidTemplateDefinition;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.AbstractValidatingTypeLoader;
import org.fabric3.spi.introspection.xml.DuplicateTemplateException;
import org.fabric3.spi.introspection.xml.LoaderRegistry;
import org.fabric3.spi.introspection.xml.LoaderUtil;
import org.fabric3.spi.introspection.xml.MissingAttribute;
import org.fabric3.spi.introspection.xml.TemplateRegistry;
import org.fabric3.spi.introspection.xml.TypeLoader;
import org.oasisopen.sca.annotation.Destroy;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class TemplateElementLoader
extends AbstractValidatingTypeLoader<ModelObject> {
    private static final QName QNAME = new QName("urn:fabric3.org", "template");
    private static final QName LAX_QNAME = new QName("", "template");
    private LoaderRegistry loaderRegistry;
    private TemplateRegistry templateRegistry;

    public TemplateElementLoader(@Reference LoaderRegistry loaderRegistry, @Reference TemplateRegistry templateRegistry) {
        this.loaderRegistry = loaderRegistry;
        this.templateRegistry = templateRegistry;
        this.addAttributes(new String[]{"name"});
    }

    @Init
    public void init() {
        this.loaderRegistry.registerLoader(QNAME, (TypeLoader)this);
        this.loaderRegistry.registerLoader(LAX_QNAME, (TypeLoader)this);
    }

    @Destroy
    public void destroy() {
        this.loaderRegistry.unregisterLoader(QNAME);
        this.loaderRegistry.unregisterLoader(LAX_QNAME);
    }

    public ModelObject load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        Location startLocation = reader.getLocation();
        this.validateAttributes(reader, context, new ModelObject[0]);
        String name = reader.getAttributeValue(null, "name");
        if (name == null) {
            MissingAttribute error = new MissingAttribute("Template name not specified", startLocation, new ModelObject[0]);
            context.addError((ValidationFailure)error);
            LoaderUtil.skipToEndElement((XMLStreamReader)reader);
            return null;
        }
        int val = reader.nextTag();
        if (val == 2 && reader.getName().getLocalPart().equals("template")) {
            InvalidTemplateDefinition error = new InvalidTemplateDefinition("Template body is missing: " + name, startLocation);
            context.addError((ValidationFailure)error);
            return null;
        }
        try {
            URI uri = context.getContributionUri();
            ModelObject parsed = (ModelObject)this.loaderRegistry.load(reader, ModelObject.class, context);
            this.templateRegistry.register(name, uri, parsed);
            LoaderUtil.skipToEndElement((XMLStreamReader)reader);
        }
        catch (DuplicateTemplateException e) {
            DuplicateTemplate error = new DuplicateTemplate(name, startLocation);
            context.addError((ValidationFailure)error);
        }
        return null;
    }
}

