/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.xml.composite;

import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.api.model.type.component.PropertyMany;
import org.fabric3.api.model.type.component.PropertyValue;
import org.fabric3.introspection.xml.common.AbstractExtensibleTypeLoader;
import org.fabric3.introspection.xml.common.InvalidAttributes;
import org.fabric3.introspection.xml.common.InvalidPropertyValue;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.InvalidPrefixException;
import org.fabric3.spi.introspection.xml.InvalidValue;
import org.fabric3.spi.introspection.xml.LoaderHelper;
import org.fabric3.spi.introspection.xml.LoaderRegistry;
import org.fabric3.spi.introspection.xml.LoaderUtil;
import org.fabric3.spi.introspection.xml.MissingAttribute;
import org.oasisopen.sca.annotation.Reference;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class PropertyValueLoader
extends AbstractExtensibleTypeLoader<PropertyValue> {
    private static final QName PROPERTY = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "property");
    private final LoaderHelper helper;

    public PropertyValueLoader(@Reference LoaderRegistry registry, @Reference LoaderHelper helper) {
        super(registry);
        this.addAttributes(new String[]{"name", "source", "file", "type", "element", "value", "many"});
        this.helper = helper;
    }

    @Override
    public QName getXMLType() {
        return PROPERTY;
    }

    public PropertyValue load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        Location startLocation = reader.getLocation();
        String name = reader.getAttributeValue(null, "name");
        if (name == null || name.length() == 0) {
            MissingAttribute failure = new MissingAttribute("Missing name attribute", startLocation, new ModelObject[0]);
            context.addError((ValidationFailure)failure);
            return null;
        }
        String source = reader.getAttributeValue(null, "source");
        String file = reader.getAttributeValue(null, "file");
        String typeAttribute = reader.getAttributeValue(null, "type");
        QName type = null;
        if (source != null) {
            PropertyValue value = new PropertyValue(name, source);
            value.setType(type);
            if (typeAttribute != null) {
                try {
                    type = this.helper.createQName(typeAttribute, reader);
                    value.setType(type);
                }
                catch (InvalidPrefixException e) {
                    InvalidAttributes error = new InvalidAttributes("Invalid property type namespace:" + e.getMessage(), startLocation, (ModelObject)value);
                    context.addError((ValidationFailure)error);
                }
            }
            this.validateAttributes(reader, context, new ModelObject[]{value});
            LoaderUtil.skipToEndElement((XMLStreamReader)reader);
            return value;
        }
        if (file != null) {
            try {
                URI uri = new URI(file);
                if (!uri.isAbsolute()) {
                    uri = context.getSourceBase().toURI().resolve(uri);
                }
                PropertyValue value = new PropertyValue(name, uri);
                if (typeAttribute != null) {
                    try {
                        type = this.helper.createQName(typeAttribute, reader);
                    }
                    catch (InvalidPrefixException e) {
                        InvalidAttributes error = new InvalidAttributes("Invalid property type namespace:" + e.getMessage(), startLocation, (ModelObject)value);
                        context.addError((ValidationFailure)error);
                    }
                }
                value.setType(type);
                this.validateAttributes(reader, context, new ModelObject[]{value});
                LoaderUtil.skipToEndElement((XMLStreamReader)reader);
                return value;
            }
            catch (URISyntaxException e) {
                InvalidValue failure = new InvalidValue("File specified for property " + name + " is invalid: " + file, startLocation, (Throwable)e, new ModelObject[0]);
                context.addError((ValidationFailure)failure);
                return null;
            }
        }
        return this.loadInlinePropertyValue(name, reader, startLocation, context);
    }

    private PropertyValue loadInlinePropertyValue(String name, XMLStreamReader reader, Location location, IntrospectionContext context) throws XMLStreamException {
        String typeAttribute = reader.getAttributeValue(null, "type");
        String elementAttribute = reader.getAttributeValue(null, "element");
        PropertyMany many = this.parseMany(reader);
        String valueAttribute = reader.getAttributeValue(null, "value");
        PropertyValue propertyValue = new PropertyValue(name, many);
        this.validateAttributes(reader, context, new ModelObject[]{propertyValue});
        Document value = this.helper.loadPropertyValues(reader);
        if (valueAttribute != null) {
            NodeList childNodes = value.getDocumentElement().getChildNodes();
            if (valueAttribute != null && childNodes.getLength() > 0 && childNodes.item(0).getTextContent().length() > 0) {
                InvalidPropertyValue error = new InvalidPropertyValue("Property value configured using a value attribute and inline: " + name, location, (ModelObject)propertyValue);
                context.addError((ValidationFailure)error);
                return propertyValue;
            }
            value = this.helper.loadPropertyValue(valueAttribute);
        }
        propertyValue.setValue(value);
        QName type = null;
        QName element = null;
        if (typeAttribute != null) {
            if (elementAttribute != null) {
                InvalidValue failure = new InvalidValue("Cannot supply both type and element for property: " + name, location, new ModelObject[0]);
                context.addError((ValidationFailure)failure);
            }
            try {
                type = this.helper.createQName(typeAttribute, reader);
            }
            catch (InvalidPrefixException e) {
                InvalidAttributes error = new InvalidAttributes("Invalid property type namespace:" + e.getMessage(), location, (ModelObject)propertyValue);
                context.addError((ValidationFailure)error);
            }
        } else if (elementAttribute != null) {
            try {
                element = this.helper.createQName(elementAttribute, reader);
            }
            catch (InvalidPrefixException e) {
                InvalidAttributes error = new InvalidAttributes("Invalid property element namespace:" + e.getMessage(), location, (ModelObject)propertyValue);
                context.addError((ValidationFailure)error);
            }
        }
        propertyValue.setElement(element);
        propertyValue.setType(type);
        return propertyValue;
    }

    private PropertyMany parseMany(XMLStreamReader reader) {
        String manyAttribute = reader.getAttributeValue(null, "many");
        if (manyAttribute == null) {
            return PropertyMany.NOT_SPECIFIED;
        }
        if (manyAttribute.equalsIgnoreCase("true")) {
            return PropertyMany.MANY;
        }
        return PropertyMany.SINGLE;
    }
}

