/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.xml.binding;

import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.api.model.type.component.BindingHandler;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.AbstractValidatingTypeLoader;
import org.fabric3.spi.introspection.xml.InvalidValue;
import org.oasisopen.sca.annotation.EagerInit;

@EagerInit
public class BindingHandlerLoader
extends AbstractValidatingTypeLoader<BindingHandler> {
    private static final BindingHandler INVALID_DEFINITION = new BindingHandler(URI.create("Invalid"));

    public BindingHandlerLoader() {
        this.addAttributes(new String[]{"target"});
    }

    public BindingHandler load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        Location startLocation = reader.getLocation();
        String target = reader.getAttributeValue(null, "target");
        if (target == null || "".equals(target)) {
            InvalidValue error = new InvalidValue("Target attribute is not specified", startLocation, new ModelObject[0]);
            context.addError((ValidationFailure)error);
            this.validateAttributes(reader, context, new ModelObject[]{INVALID_DEFINITION});
            return INVALID_DEFINITION;
        }
        try {
            URI targetUri = new URI(target);
            BindingHandler definition = new BindingHandler(targetUri);
            this.validateAttributes(reader, context, new ModelObject[]{definition});
            return definition;
        }
        catch (URISyntaxException e) {
            InvalidValue error = new InvalidValue("Target attribute is not a valid URI: " + target, startLocation, new ModelObject[0]);
            context.addError((ValidationFailure)error);
            this.validateAttributes(reader, context, new ModelObject[]{INVALID_DEFINITION});
            return INVALID_DEFINITION;
        }
    }
}

